

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title><?php echo e($data['report_id']); ?> | <?php echo e(config('app.name', 'Lensaudit')); ?> | <?php echo e($page_title); ?></title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
  <style>
    .page-break {
        page-break-after: always;
    }
    @page {
        margin: 60px;
        border: 1px solid #adadad;
        border-radius: 5px;
    }
    .border{
        border: 2.5px solid #c5c6c6;
        background-color: #fff;
        border-radius: 15px;
        padding: 10px;
        margin: 0 10px;
    }
    .border-score{
        border: 2.5px solid #c5c6c6;
        background-color: #fff;
        border-radius: 15px;
        padding: 10px;
        margin: 0 10px;
    }
    .border-score img{
        width: 100%;
        border-radius: 100%;
        border: 2px solid #c5c6c6;
    }
    .list-element img{
        width: 100%;
        border-radius: 100%;
        border: 2px solid #c5c6c6;
    }
    .top-space{
        margin-top: 20px;
    }
    body{
      /* font-size: 16px; */
      /* font-family: "Montserrat", sans-serif; */
      font-family: "Poppins", serif;
      font-style: normal;
      font-weight: 400 !important;
      color: #353535 !important;
    }
    h1{
      font-size: 2em;
    }
    h2{
      font-size: 1.5em;
    }
    h1,h2,h3,h4,h5,h6{
      font-weight: 500 !important;
    }
    section{
      margin: 30px;
    }
    table, th, td{
      /* border-radius: 5px; */
    }
    .score table, th, td {
      /* border: 1px solid; */
      text-align: left;
      border-spacing: 4px;
    }
    .score th, td {
        border: 1px solid #adadad;
        padding: 5px 15px;
    }
    .font-14{
      font-size: 14px;
    }
    .font-15{
      font-size: 15px;
    }
    .font-16{
      font-size: 16px;
    }
    .text-slim{
      font-weight: 400 !important;
    }
    .text-normal{
      font-weight: 500 !important;
    }
    .text-bold{
      font-weight: 600 !important;
    }
    .text-uppercase{
      text-transform: uppercase;
    }
    .info{
      background-color: #00cfe8 !important;
      color: #ffffff !important;
      border-color: #00cfe8 !important;
    }
    .warning{
      background-color: #ff9f43 !important;
      color: #ffffff !important;
      border-color: #ff9f43 !important;
    }
    .danger{
      background-color: #ea5455 !important;
      color: #ffffff !important;
      border-color: #ea5455 !important;
    }
    .success{
      background-color: #28c76f !important;
      color: #ffffff !important;
      border-color: #28c76f !important;
    }
    .secondary{
      background-color: #c0c0c0 !important;
      color: #ffffff !important;
      border-color: #c0c0c0 !important;
    }
    .auditor{
      padding: 4px;
    }
    .auditor table, th, td {
      border: 1px solid #adadad;
      border-collapse: collapse;
      padding: 15px;
    }
    .overview{
      padding: 4px;
    }
    .overview table, th {
      border: 1px solid #adadad;
      border-collapse: collapse;
      padding: 15px;
    }
    .overview table thead th{
      font-weight: 600 !important;
    }
    .overview table tbody td{
      font-weight: 400 !important;
      padding: 8px 15px;
      border: 1px solid #adadad;
    }
    .light{
      background: #dddddd;
    }
    .dark{
      background: #979797;
      color: #fff;
    }
    .mb{
      margin-bottom: 20px;
    }
    .col {
      flex: 0 0 auto;
      width: 19%;
    }
    .mr{
      margin-right: 10px;
    }
    .declaration{
      padding: 4px;
    }
    .declaration table, th {
      border: 1px solid #adadad;
      border-collapse: collapse;
      padding: 15px;
    }
    .declaration table thead th{
      font-weight: 600 !important;
    }
    .declaration table tbody td{
      font-weight: 400 !important;
      padding: 8px 15px;
      border: 0px solid #adadad;
    }
    .avatar .avatar-initial {
      position: relative;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      text-transform: uppercase;
      display: flex;
      align-items: center;
      justify-content: center;
      color: #fff;
      background-color: #c9c8ce;
      font-weight: 500;
      width: 120px;
      height: 120px;
      border-radius: 10px;
   }
  </style>

</head>
<body>
  <section>
    <div style="padding: 0 4px">
      
      <div class="avatar avatar-xl me-2" style="width: 120px;height: 120px;margin-bottom: 20px">
         <h1><span class="avatar-initial rounded bg-label-info">
         <?php
            $str = $data['company_name'];
            $words = explode(' ', $str);
            $result = $words[0][0];
            echo $result;
         ?>
         </span></h1>
      </div>
    </div>
    <div class="score mb">
      <table style="width: 100%;">
        <tbody>
          <tr>
            <th style="width: 30%;">
               <span class="text-bold text-uppercase">Audit ID</span><br>
               <span class="text-slim font-14">#<?php echo e($data['report_id']); ?></span>
            </th>
            <?php
               $statuses = [
                  '0' => ['label' => 'In Progress', 'class' => 'warning'],
                  '1' => ['label' => 'In Review', 'class' => 'info'],
                  '2' => ['label' => 'Completed', 'class' => 'success'],
                  '3' => ['label' => 'Rejected', 'class' => 'danger'],
               ];
            ?>
            
            <?php
               $total_question = $data['total_question'] ?? 0;
               $total_ques_answered = $data['total_answer'] ?? 0;
               $percent = ($total_question > 0) ? round(($total_ques_answered / $total_question) * 100, 0) : 0;

               // dd($data['results']['percentage']);
               foreach ($data['results'] as $results) {
                  $percentage = (int)$results['percentage'];
                  
                  if (
                     (round($percent) == $percentage)
                  ) {
                     $symbol = $results['symbols'];
                     $color = $results['color'];
                     $message = $results['name'];
                  }
               }
            ?>
            <th class="<?php echo e($statuses[$data['status']]['class']); ?>" style="width: 30%;">
               <span class="text-bold text-uppercase">Status</span><br>
               <span class="text-slim font-14">
                  <?php echo e($statuses[$data['status']]['label']); ?>

               </span>
            </th>
            <th style="width: 40%;background-color: <?php echo e($color); ?>;border-color: <?php echo e($color); ?>;color:white !important;">
               <span class="text-bold text-uppercase">Result</span><br>
               <span class="text-slim font-14"><?php echo e($message); ?> ( <?php echo e($symbol); ?> <?php echo e($percent); ?>%)</span>
            </th>
          </tr>
        </tbody>
      </table>
    </div>
    <div class="auditor mb">
      <table style="width: 100%;">
        <tbody>
          <tr>
            <th class="text-bold text-uppercase" style="width: 40%;">Score</th>
            <th class="text-slim" style="width: 60%;"><?php echo e($data['total_answer'] * 100); ?>/<?php echo e($data['total_question'] * 100); ?> <?php echo e($percent); ?>%</th>
          </tr>
          <tr>
            <th class="text-bold text-uppercase" style="width: 40%;">Conducted by</th>
            <th class="text-slim" style="width: 60%;"><?php echo e($data['submitted_by_name']); ?></th>
          </tr>
          <tr>
            <th class="text-bold text-uppercase" style="width: 40%;">Company Name</th>
            <th class="text-slim" style="width: 60%;"><?php echo e($data['company_name']); ?></th>
          </tr>
          <tr>
            <th class="text-bold text-uppercase" style="width: 40%;">Conducted on</th>
            <th class="text-slim" style="width: 60%;"><?php echo e($data['date']); ?></th>
          </tr>
          <tr>
            <th class="text-bold text-uppercase" style="width: 40%;">Location</th>
            <th class="text-slim" style="width: 60%;"><?php echo e($data['location']); ?></th>
          </tr>
        </tbody>
      </table>
    </div>
    <div class="overview">
      <table width="100%">
         <thead>
            <tr class="dark">
               <th colspan="5" style="font-size: 18px">Overview</th>
               
            </tr>
            <tr class="light">
               <th width="56%">Section</th>
               <th width="10%">Questions</th>
               <th width="10%">Answered</th>
               <th colspan="2" width="24%">Score</th>
            </tr>
         </thead>
         <tbody>
            <?php $__currentLoopData = $data['section']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
               <?php
                  $total_question = $section['section_total_question'] ?? 0;
                  $total_ques_answered = $section['section_total_answer'] ?? 0;
                  $percent = ($total_question > 0) ? round(($total_ques_answered / $total_question) * 100, 0) : 0;

                  // Assign colors based on percentage range
                  if ($percent <= 25) {
                        $color = 'danger'; // Red
                  } elseif ($percent <= 50) {
                        $color = 'warning'; // Yellow
                  } elseif ($percent <= 75) {
                        $color = 'info'; // Blue
                  } else {
                        $color = 'success'; // Green
                  }
               ?>

               <tr>
                  <td><?php echo e($section['section_name']); ?></td>
                  <td><?php echo e($section['section_total_answer']); ?></td>
                  <td><?php echo e($section['section_total_question']); ?></td>
                  <td><?php echo e($section['section_total_answer'] *100); ?> / <?php echo e($section['section_total_question'] *100); ?></td>
                  <td class="<?php echo e($color); ?>"><?php echo e($percent); ?>%</td>
               </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
         </tbody>
      </table>
    </div>
  </section>
  <div class="page-break"></div>
  <section>
   <div class="overview mb">
      

      <?php $__currentLoopData = $data['section']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
         <table width="100%" class="mb">
            <thead>
                  <tr class="dark">
                     <th style="font-size: 18px"><?php echo e($section['section_name']); ?></th>
                     <th>
                        <span class="text-bold text-uppercase font-14">Score</span><br>
                        <span class="text-slim font-14">
                              <?php echo e($section['section_total_answer'] * 100); ?>/<?php echo e($section['section_total_question'] * 100); ?>

                        </span>
                     </th>
                  </tr>
                  <tr class="light">
                     <th width="85%">Questions</th>
                     <th width="15%">Response</th>
                  </tr>
            </thead>
            <tbody>
                  <?php if(!empty($section['section_question'])): ?>
                     <?php $__currentLoopData = $section['section_question']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                              // Assign colors based on the response
                              $response = strtolower($question['questions_answer'] ?? '');
                              if (in_array($response, ['yes', 'correct'])) {
                                 $color = 'success';
                              } elseif (in_array($response, ['partial', 'maybe'])) {
                                 $color = 'warning';
                              } elseif (in_array($response, ['no', 'incorrect'])) {
                                 $color = 'danger'; 
                              } else {
                                 $color = 'secondary';
                              }
                        ?>

                        <tr>
                              <td><?php echo e($question['title']); ?></td>
                              <td class="<?php echo e($color); ?>"><?php echo e($question['questions_answer']); ?></td>
                        </tr>

                        <?php if(!empty($question['questions_comment'])): ?>
                              <tr>
                                 <td colspan="2">
                                    <span class="font-15 text-bold">Comment</span><br>
                                    <span class="font-14 text-slim"><?php echo e($question['questions_comment']); ?></span>
                                 </td>
                              </tr>
                        <?php endif; ?>

                        <?php if(!empty($question['questions_image'])): ?>
                              <tr>
                                 <td colspan="2">
                                    <span class="font-15 text-bold">Images</span><br>
                                    <div style="display: flex; margin-top: 8px;">
                                          <?php $__currentLoopData = $question['questions_image']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                             <div class="col mr">
                                                <img src="<?php echo e($data['question_image'] . $image); ?>" 
                                                      alt="Image <?php echo e($index); ?>" 
                                                      style="border-radius: 5px; width: 100%; border: 1px solid #dddddd;">
                                             </div>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                 </td>
                              </tr>
                        <?php endif; ?>
                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  <?php endif; ?>
            </tbody>
         </table>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
   </div>
   <div class="declaration mb">
      <table width="100%" style="padding: 0 15px;border: 0px;">
         <tr>
            <th width="50%" style="padding: 0 15px 0 0;border: 0px;">
               <table width="100%">
                  <thead>
                     <tr class="dark">
                        <th colspan="2" style="font-size: 18px">Confirmed by</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td width="40%">
                           <div>
                              <img src="<?php echo e($data['signature_image']); ?>" alt="" width="100%">
                           </div>
                        </td>
                        <td width="60%" style="vertical-align: text-top;">
                           <div>
                              <small><b>#AU-31E27</b></small><br>
                              <span><?php echo e($data['submitted_by_name']); ?></span><br>
                              <span><?php echo e($data['date']); ?></span>
                           </div>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </th>
            <th width="50%" style="padding: 0 15px 0 0;border: 0px;"></th>
            
         </tr>
         
      </table>
   </div>
  </section>
</body>
</html><?php /**PATH C:\wamp64\www\projects\app_leadaudits360\resources\views/pages/reports/print.blade.php ENDPATH**/ ?>