
<?php $__env->startSection('content'); ?>

        <div class="container flex-grow-1 container-p-y">
            <div class="card mb-4">
                <h5 class="card-header">Update Auditor</h5>
                <div class="card-body">
                    
                        
                    <form id="auditorFormUpdate" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-6 mb-3">
                                <div class="form">
                                    <!-- <label for="formFile" class="form-label">Profile Image</label> -->
                                    <input class="form-control" type="file" id="formFile" name="images">
                                </div>
                                <span id="imagesError" class="error"></span>
                            </div>
                            <div class="col-6 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select id="company_id" class="selectpicker w-100" data-style="btn-default" id="company_id" name="company_id">
                                    <option value="">Select Company</option>
                                    <?php if(!empty($companies['data']['department_list'])): ?>
                                    <?php $__currentLoopData = $companies['data']['department_list']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($company['id']); ?>" <?php echo e($auditors['data']['Auditors'][0]['company_id'] == $company['id'] ? 'selected' : ''); ?>><?php echo e($company['company_name']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                                <span id="company_idError" class="error"></span>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control"  placeholder="" aria-describedby="floatingInputHelp" id="firstName" name="first_name" value="<?php echo e($auditors['data']['Auditors'][0]['first_name']); ?>" />
                                    <label for="floatingInput">First Name</label>
                                    <span id="firstNameError" class="error"></span>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control" placeholder="" aria-describedby="floatingInputHelp" id="lastName" name="last_name" value="<?php echo e($auditors['data']['Auditors'][0]['last_name']); ?>"  />
                                    <label for="floatingInput">Last Name</label>
                                    <span id="lastNameError" class="error"></span>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control"  placeholder="" aria-describedby="floatingInputHelp" id="email" name="email" value="<?php echo e($auditors['data']['Auditors'][0]['email']); ?>"  />
                                    <label for="floatingInput">Email ID</label>
                                    <span id="emailError" class="error"></span>
                                </div>
                            </div>
                            <!--<div class="col-6 mb-3">-->
                            <!--    <div class="form-floating">-->
                            <!--        <input type="text" class="form-control"  placeholder="" aria-describedby="floatingInputHelp" id="password" name="password" />-->
                            <!--        <label for="floatingInput">Password</label>-->
                            <!--        <span id="passwordError" class="error"></span>-->
                            <!--    </div>-->
                            <!--</div>-->
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control" placeholder="" aria-describedby="floatingInputHelp" id="jobTitle" name="job_title" value="<?php echo e($auditors['data']['Auditors'][0]['job_title']); ?>"  />
                                    <label for="floatingInput">Job Title</label>
                                    <span id="jobTitleError" class="error"></span>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select  class="selectpicker w-100 h-100" data-style="btn-default" id="time_zone" name="time_zone">
                                    <option value="">Select Timezone</option>
                                    <option value="GMT +5:30" selected>GMT +5:30</option>
                                    <option value="GMT +4">GMT +4</option>
                                </select>
                                <span id="timeZoneError" class="error"></span>
                            </div>
                             <div class="col-6 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select id="selectpickerBasic" class="selectpicker w-100 h-100" data-style="btn-default" id="status" name="status">
                                    
                                    <option value="1" selected>Active</option>
                                    <option value="2">Inactive</option>
                                </select>
                            </div>
                            <input type="hidden" class="form-control" placeholder="" aria-describedby="floatingInputHelp" id="id" name="id" value="<?php echo e($auditors['data']['Auditors'][0]['id']); ?>"  />
                            <div class="col-12">
                                <button id="auditor_update_submit" type="button" class="btn btn-primary me-sm-3 me-1 waves-effect waves-light">Submit</button>
                                <button type="reset" class="btn btn-label-secondary waves-effect">Cancel</button>
                            </div>
                        </div>
                    </form>
                    
                </div>
            </div>
        </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascripts'); ?>
<script src="<?php echo e(asset('assets/js/forms-file-upload.js')); ?>"></script>

<script>
    document.addEventListener('DOMContentLoaded', function (e) {
        

const formupdateRecord = document.getElementById('auditorFormUpdate');

if (!formupdateRecord) {
    console.error('Form not found!');
    return;
}

// Form validation for Add new record
fv = FormValidation.formValidation(formupdateRecord, {
    fields: {
        company_id: {
            validators: {
                notEmpty: {
                    message: 'Company is required'
                }
            }
        },
        first_name: {
                validators: {
                    notEmpty: {
                        message: 'First Name is required'
                    }
                }
            },
            last_name: {
                validators: {
                    notEmpty: {
                        message: 'Last Name is required'
                    }
                }
            },
            email: {
                validators: {
                    notEmpty: {
                        message: 'Email is required'
                    },
                    emailAddress: {
                        message: '* Please enter a valid email address'
                    }
                }
            },
            job_title: {
                validators: {
                    notEmpty: {
                        message: 'Job Title is required'
                    }
                }
            },
            time_zone: {
                validators: {
                    notEmpty: {
                        message: 'Time Zone is required'
                    }
                }
            }
    },
    plugins: {
        trigger: new FormValidation.plugins.Trigger(),
        bootstrap5: new FormValidation.plugins.Bootstrap5({
            rowSelector: '.col-6, .col-12'
        }),
        submitButton: new FormValidation.plugins.SubmitButton(),
        autoFocus: new FormValidation.plugins.AutoFocus()
    },
    init: instance => {
        instance.on('plugins.message.placed', function (e) {
            if (e.element.parentElement.classList.contains('form-floating')) {
                e.element.parentElement.insertAdjacentElement('afterend', e.messageElement);
            }
        });
    }
});

  // Clear emailError when email input gains focus
  document.getElementById('email').addEventListener('focus', function() {
        document.getElementById('emailError').innerText = '';
    });

$('#auditor_update_submit').click(function() {
                fv.validate().then(function(status) {
                    if (status === 'Valid') {
                        var updateAuditorRoute = '<?php echo e(route('update_auditor')); ?>';
                        var form = document.getElementById("auditorFormUpdate");

                        fetch(updateAuditorRoute, {
                            method: 'POST',
                            body: new FormData(form),
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.status==true) {
                                Swal.fire({
                                    title: "Updated",
                                    text: data.message,
                                    icon: "success",
                                    confirmButtonText: "OK",
                                });
                                setTimeout(function() {
                                    window.location.href = '/auditors-management'; // Replace with your redirect URL
                                }, 2000); 
                            }else if(data.errors && data.errors.email) {

                                  emailError.innerText = data.errors.email[0];
                             } else {
                                alert('An error occurred. Please try again.');
                            }
                        })
                        .catch(error => {
                            alert('Failed to update company. Please try again.');
                            console.error('Error:', error);
                        });
                    }
                });
            });
    
});
    
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/coinsocialtilti/public_html/pavan/lensaudits/resources/views/pages/users/updateauditors.blade.php ENDPATH**/ ?>