

<?php $__env->startSection('content'); ?>
<div class="container flex-grow-1 container-p-y">
    <div class="card mb-4">
        <h5 class="card-header">Create Company / Department</h5>
        <div class="card-body">
            <form id="companyForm" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-6 mb-3">
                        <div class="form">
                            <!-- <label for="formFile" class="form-label">Profile Image</label> -->
                            <input class="form-control" type="file" id="image" name="image">
                        </div>
                        <span id="imageError" class="error"></span>
                    </div>
                    <div class="col-6 mb-3">
                        <div class="form-floating">
                            <input type="text" class="form-control" id="name" name="name" placeholder="" aria-describedby="floatingInputHelp" />
                            <label for="name">Company / Department Name</label>
                            
                            
                        </div>
                    </div>
                    <div class="col-12">
                        <label>Select Default Time</label>
                    </div>
                    <div class="col-6 mb-3">
                        <div class="form-floating">
                            <input type="time" class="form-control" id="schedules_start_time" name="schedules_start_time" placeholder="" aria-describedby="floatingInputHelp" />
                            <label for="floatingInput">Start Time</label>
                            <span id="schedules_start_timeError" class="error"></span>
                        </div>
                    </div>
                    <div class="col-6 mb-3">
                        <div class="form-floating">
                            <input type="time" class="form-control" id="schedules_end_time" name="schedules_end_time" placeholder="" aria-describedby="floatingInputHelp" />
                            <label for="floatingInput">End Time</label>
                            <span id="schedules_end_timeError" class="error"></span>
                        </div>
                    </div>

                    <div class="col-12">
                        <button id="company_submit" type="button" class="btn btn-primary me-sm-3 me-1 waves-effect waves-light">Submit</button>
                        <a href="<?php echo e(url()->previous()); ?>" class="btn btn-label-secondary waves-effect">Cancel</a>
                    </div>
                </div>
            </form>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function (e) {

        const formAddNewRecord = document.getElementById('companyForm');

        if (!formAddNewRecord) {
            console.error('Form not found!');
            return;
        }

        // Form validation for Add new record
        fv = FormValidation.formValidation(formAddNewRecord, {
            fields: {
                name: {
                    validators: {
                        notEmpty: {
                            message: 'The name is required'
                        }
                    }
                },
                schedules_start_time: {
                    validators: {
                        notEmpty: {
                            message: 'Start time is required'
                        }
                    }
                },
                schedules_end_time: {
                    validators: {
                        notEmpty: {
                            message: 'End time is required'
                        }
                    }
                }
            },
            plugins: {
                trigger: new FormValidation.plugins.Trigger(),
                bootstrap5: new FormValidation.plugins.Bootstrap5({
                    rowSelector: '.col-6'
                }),
                submitButton: new FormValidation.plugins.SubmitButton(),
                autoFocus: new FormValidation.plugins.AutoFocus()
            },
            init: instance => {
                instance.on('plugins.message.placed', function (e) {
                    if (e.element.parentElement.classList.contains('form-floating')) {
                        e.element.parentElement.insertAdjacentElement('afterend', e.messageElement);
                    }
                });
            }
        });

        $('#company_submit').click(function() {
                fv.validate().then(function(status) {
                    if (status === 'Valid') {
                        var addCompanyRoute = '<?php echo e(route('add_company')); ?>';
                        var form = document.getElementById("companyForm");

                        fetch(addCompanyRoute, {
                            method: 'POST',
                            body: new FormData(form),
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.status==true) {
                                Swal.fire({
                                    title: "Created",
                                    text: data.message,
                                    icon: "success",
                                    confirmButtonText: "OK",
                                });
                                setTimeout(function() {
                                    window.location.href = '/company-department'; // Replace with your redirect URL
                                }, 2000); 
                            } else {
                                alert('An error occurred. Please try again.');
                            }
                        })
                        .catch(error => {
                            alert('Failed to add company. Please try again.');
                            console.error('Error:', error);
                        });
                    }
                });
            });




    });

    
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\projects\app_leadaudits360\resources\views/pages/users/createcompanydepartment.blade.php ENDPATH**/ ?>