

<?php $__env->startSection('content'); ?>
        <div class="container flex-grow-1 container-p-y">
            <div class="card mb-4">
                <h5 class="card-header">Update Company / Department</h5>
                <div class="card-body">
                    <form id="companyFormUpdate" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-6 mb-3">
                                <div class="form">
                                    <!-- <label for="formFile" class="form-label">Profile Image</label> -->
                                    <input class="form-control" type="file" id="image" name="image">
                                </div>
                                <span id="imageError" class="error"></span>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="name" name="name" placeholder="" aria-describedby="floatingInputHelp" value="<?php echo e($department['data']['department'][0]['name']); ?>" />
                                    <label for="floatingInput">Company / Department Name</label>
                                    <span id="nameError" class="error"></span>

                                </div>
                            </div>
                            <div class="col-12">
                                <label>Select Default Time</label>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="time" class="form-control" id="schedules_start_time" name="schedules_start_time" placeholder="" aria-describedby="floatingInputHelp" value="<?php echo e($department['data']['department'][0]['schedules_start_time']); ?>" />
                                    <label for="floatingInput">Start Time</label>
                                    <span id="schedules_start_timeError" class="error"></span>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="time" class="form-control" id="schedules_end_time" name="schedules_end_time" placeholder="" aria-describedby="floatingInputHelp" value="<?php echo e($department['data']['department'][0]['schedules_end_time']); ?>" />
                                    <label for="floatingInput">End Time</label>
                                    <span id="schedules_end_timeError" class="error"></span>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select id="selectpickerBasic" class="selectpicker w-100 h-100" data-style="btn-default" id="status" name="status">
                                    
                                    <option value="1" selected>Active</option>
                                    <option value="2">Inactive</option>
                                </select>
                            </div>
                            <input type="hidden" class="form-control" placeholder="" aria-describedby="floatingInputHelp" id="id" name="id" value="<?php echo e($department['data']['department'][0]['id']); ?>"  />
                            
                            <div class="col-12">
                                <button id="company_update_submit" type="button" class="btn btn-primary me-sm-3 me-1 waves-effect waves-light">Submit</button>
                                <button type="reset" class="btn btn-label-secondary waves-effect">Cancel</button>
                            </div>
                        </div>
                    </form>
                    
                </div>
            </div>
        </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascripts'); ?>
<!-- <script src="<?php echo e(asset('assets/datatable/users-datatables.js')); ?>"></script> -->
<script src="<?php echo e(asset('assets/js/forms-file-upload.js')); ?>"></script>

<script>
    document.addEventListener('DOMContentLoaded', function (e) {

        const formUpdateNewRecord = document.getElementById('companyFormUpdate');

        if (!formUpdateNewRecord) {
            console.error('Form not found!');
            return;
        }

        // Form validation for Add new record
        fv = FormValidation.formValidation(formUpdateNewRecord, {
            fields: {
                name: {
                    validators: {
                        notEmpty: {
                            message: 'The name is required'
                        }
                    }
                },
                schedules_start_time: {
                    validators: {
                        notEmpty: {
                            message: 'Start time is required'
                        }
                    }
                },
                schedules_end_time: {
                    validators: {
                        notEmpty: {
                            message: 'End time is required'
                        }
                    }
                }
            },
            plugins: {
                trigger: new FormValidation.plugins.Trigger(),
                bootstrap5: new FormValidation.plugins.Bootstrap5({
                    rowSelector: '.col-6'
                }),
                submitButton: new FormValidation.plugins.SubmitButton(),
                autoFocus: new FormValidation.plugins.AutoFocus()
            },
            init: instance => {
                instance.on('plugins.message.placed', function (e) {
                    if (e.element.parentElement.classList.contains('form-floating')) {
                        e.element.parentElement.insertAdjacentElement('afterend', e.messageElement);
                    }
                });
            }
        });

        $('#company_update_submit').click(function() {
                fv.validate().then(function(status) {
                    if (status === 'Valid') {
                        var updateCompanyRoute = '<?php echo e(route('update_company')); ?>';
                        var form = document.getElementById("companyFormUpdate");

                        fetch(updateCompanyRoute, {
                            method: 'POST',
                            body: new FormData(form),
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.status==true) {
                                Swal.fire({
                                    title: "Updated",
                                    text: data.message,
                                    icon: "success",
                                    confirmButtonText: "OK",
                                });
                                setTimeout(function() {
                                    window.location.href = '/company-department'; // Replace with your redirect URL
                                }, 2000); 
                            } else {
                                alert('An error occurred. Please try again.');
                            }
                        })
                        .catch(error => {
                            alert('Failed to update company. Please try again.');
                            console.error('Error:', error);
                        });
                    }
                });
            });




    });

    
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/coinsocialtilti/public_html/pavan/lensaudits/resources/views/pages/users/updatecompanydepartment.blade.php ENDPATH**/ ?>