
<!DOCTYPE html>
<html
  lang="<?php echo e(config('app.locale')); ?>"
  class="light-style layout-navbar-fixed layout-menu-fixed layout-compact"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="<?php echo e(asset('assets')); ?>/"
  data-template="vertical-menu-template-no-customizer">

  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title><?php echo e($page_title); ?> | <?php echo e(config('app.name', 'Lensaudit')); ?></title>

    
    <meta name="description" content="" />
    <meta name="keywords" content="">
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('assets/img/favicon/favicon.ico')); ?>" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&ampdisplay=swap" rel="stylesheet">

    <!-- Icons -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/fonts/fontawesome.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/fonts/tabler-icons.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/fonts/flag-icons.css')); ?>" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/rtl/core.css" class="template-customizer-core-css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/rtl/theme-default.css" class="template-customizer-theme-css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/demo.css')); ?>" />
    
    <!-- Vendors CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/node-waves/node-waves.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/typeahead-js/typeahead.css')); ?>" /> 
    

    <!-- Page CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/pages/app-invoice-print.css')); ?>" />

    <!-- Helpers -->
    <script src="<?php echo e(asset('assets/vendor/js/helpers.js')); ?>"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Template customizer: To hide customizer set displayCustomizer value false in config.js.  -->
    <script src="<?php echo e(asset('assets/vendor/js/template-customizer.js')); ?>"></script>
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="<?php echo e(asset('assets/js/config.js')); ?>"></script>
    
    <style>
      .invoice-print{
        min-width: 768px !important;
        font-size: 17px !important;
      }
      .invoice-print * {
          color: #353535 !important;
      }
      table, th, td {
        border: 1px solid #353535;
        border-collapse: collapse;
      }
      .table p{
        text-transform:none !important;
        font-weight: 600;
        font-size: 15px !important;
      }
      .table .table-light th {
          font-weight: 600;
          font-size: 15px !important;
      }
    </style>
</head>

<body>
  <!-- Content -->
  <div class="invoice-print p-2">
    
    <div class="row">
      <div class="col-4 mb-5">
        <!--<img src="https://socialtitli.com/assets/images/logo.png" alt="" class="w-100">-->
        <div class="avatar avatar-xl me-2" style="width: 6.5rem;height: 6.5rem;">
                
                <span class="avatar-initial rounded bg-label-info">
                    <?php
                        $str = $data['company_name'];
                        $words = explode(' ', $str);
                        $result = $words[0][0];
                        echo $result;
                    ?>
                </span>
            </div>
      </div>
      <div class="col-12 mb-3">
        <h1 class="mb-0">Inspection</h1>
      </div>

      <div class="col-12 mb-1">
        <table class="table table-bordered m-0">
          <thead class="table-light">
            
            <tr>
              <th>
                <h6 class="mb-0"><?php echo e($data['total_answer']); ?>/<?php echo e($data['total_question']); ?> 
                  <?php
                    $total_question = $data['total_question'];
                    $total_ques_answered = $data['total_answer'];
                    $percent_total = $total_ques_answered / $total_question * 100;
                    $percent = round($percent_total, 0);
                    echo $percent.'%';
                  ?>
                </h6>
                <strong>Score</strong>
              </th>
              <th>
                <h6 class="mb-0"><?php echo e($data['submitted_by_name']); ?></h6>
                <strong>Conducted by</strong>
              </th>
              <th>
                <h6 class="mb-0">
                    <?php if($data['status']== '0'): ?>
                      In Progress
                  <?php endif; ?>
                  <?php if($data['status']== '1'): ?>
                  In Review
                  <?php endif; ?>
                  <?php if($data['status']== '2'): ?>
                  Completed
                  <?php endif; ?>
                  <?php if($data['status']== '3'): ?>
                  Rejected
                  <?php endif; ?>
                </h6>
                <strong>Status</strong>
              </th>
            </tr>
          </thead>
        </table>
      </div>
      <div class="col-12 mb-5">
        <table class="table table-bordered-black">
          <tbody>
            <tr>
              <th class="col-6"><h6 class="mb-0"><strong>Audit ID</strong></h6></th>
              <th class="col-6"><p class="mb-0">#<?php echo e($data['report_id']); ?></p></th>
            </tr>
            
            <tr>
              <th class="col-6"><h6 class="mb-0"><strong>Company Name</strong></h6></th>
              <th class="col-6"><p class="mb-0"><?php echo e($data['company_name']); ?></p></th>
            </tr>
            <tr>
              <th class="col-6"><h6 class="mb-0"><strong>Conducted on</strong></h6></th>
              <th class="col-6"><p class="mb-0"><?php echo e($data['date']); ?></p></th>
            </tr>
            <tr>
              <th class="col-6"><h6 class="mb-0"><strong>Location</strong></h6></th>
              <th class="col-6"><p class="mb-0"><?php echo e($data['location']); ?></p></th>
            </tr>
          </tbody>
        </table>
      </div>
      <div class="col-12 mt-3 mb-5">
        <div class="row">
          <div class="col-12">
            <div class="card table-responsive shadow-none bg-transparent border border-secondary p-0 mb-5">
              <table class="table m-0">
                <thead class="table-light">
                  <tr>
                    <th colspan="4">
                      <h5 class="mb-0"><strong>Overview</strong></h5>
                    </th>
                  </tr>
                   <tr>
                      <th>Section</th>
                      <th>Answered</th>
                      <th>Question</th>
                      <th>%</th>
                   </tr>
                </thead>
                <tbody>
                  <?php for($ia = 0; $ia < count($data['section']); $ia++): ?>
                  <tr>
                    <td><?php echo e($data['section'][$ia]['section_name']); ?></td>
                    <td><?php echo e($data['section'][$ia]['section_total_answer']); ?></td>
                    <td><?php echo e($data['section'][$ia]['section_total_question']); ?></td>
                    <td>
                      <?php
                        $total_question = $data['section'][$ia]['section_total_question'];
                        $total_ques_answered = $data['section'][$ia]['section_total_answer'];
          
                        if($total_question != 0){
                          $percent_total = $total_ques_answered / $total_question * 100;
                          $percent = round($percent_total, 0);
                          echo $percent.'%';
                        }else{
                          $percent = 0;
                          echo $percent.'%';
                        }
                      ?>
                    </td>
                  </tr>
                  <?php endfor; ?>
                </tbody>
             </table>
            </div>
          </div>
        </div>
      </div>
      
      <?php for($ia = 0; $ia < count($data['section']); $ia++): ?>
      <div class="col-12 mb-2">
        <div class="row">
          <div class="col-12">
            <div class="card table-responsive shadow-none bg-transparent border border-secondary p-0 mb-5">
              <table class="table m-0">
                <thead class="table-light">
                  <tr class="table-dark">
                    <th colspan="4">
                      <h5 class="mb-0"><strong style="color: #ffffff !important"><?php echo e($data['section'][$ia]['section_name']); ?></strong></h5>
                    </th>
                  </tr>
                   <tr>
                      <th>#</th>
                      <th>Question</th>
                      <th>RESPONSE</th>
                   </tr>
                </thead>
                <tbody>
                  <?php if($data['section'][$ia]['section_question'] != null): ?>
                  <?php for($aa = 0; $aa < count($data['section'][$ia]['section_question']); $aa++): ?>
                  <tr>
                    <td><?php echo e($data['section'][$ia]['section_question'][$aa]['questions_id']); ?></td>
                    <td><?php echo e($data['section'][$ia]['section_question'][$aa]['title']); ?></td>
                    <td><?php echo e($data['section'][$ia]['section_question'][$aa]['questions_answer']); ?></td>
                  </tr>
                  <?php if(!empty($data['section'][$ia]['section_question'][$aa]['questions_comment'])): ?>
                  <tr>
                      <td colspan="3">
                      <h6 class="mb-0">Comment</h6>
                      <p class="mb-0"><?php echo e($data['section'][$ia]['section_question'][$aa]['questions_comment']); ?></p>
                      </td>
                  </tr>
                  <?php endif; ?>
                  <?php if(!empty($data['section'][$ia]['section_question'][$aa]['questions_image'])): ?>
                 <tr>
                  <td colspan="3">
                      <h6 class="mb-2">Images</h6>
                      <div class="row">
                        <?php for($im = 0; $im < count($data['section'][$ia]['section_question'][$aa]['questions_image']); $im++): ?>
                        <div class="col-3 mb-3">
                          <div class="card">
                            <img class="card-img-top" src="<?php echo e($data['question_image']); ?><?php echo e($data['section'][$ia]['section_question'][$aa]['questions_image'][$im]); ?>" alt="<?php echo e($im); ?>"> 
                          </div>
                        </div>
                        <?php endfor; ?>
                        
                      </div>
                    </td>
                  </tr>
                  <?php endif; ?>
                  <?php endfor; ?>
                  <?php endif; ?>
                </tbody>
             </table>
            </div>
          </div>
        </div>
      </div>
      <?php endfor; ?>

      <div class="col-12">
        <div class="row">
          <div class="col-12">
            <div class="card border rounded">
              <div class="card-body bg-primary">
                <h5 class="card-title mb-0" style="color: #ffffff !important">Declaration</h5>
              </div>
              <div class="card-body">
                  <img class="card-img-top w-20" src="<?php echo e($data['signature_image']); ?>" alt="<?php echo e($data['submitted_by_name']); ?>"> 
                <hr>
                <span>(<?php echo e($data['submitted_by_name']); ?>)</span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- Content -->
  


<!-- / Content -->

  

  <!-- Core JS -->
  <!-- build:js assets/vendor/js/core.js -->
  
  <script src="<?php echo e(asset('assets/vendor/libs/jquery/jquery.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/popper/popper.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/js/bootstrap.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/node-waves/node-waves.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/hammer/hammer.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/i18n/i18n.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/typeahead-js/typeahead.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/js/menu.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/js/main.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/js/app-invoice-print.js')); ?>"></script>
  
</body>

</html><?php /**PATH /home/leadaudits360/public_html/app_leadaudits360/resources/views/pages/reports/print.blade.php ENDPATH**/ ?>