<!DOCTYPE html>
<html
  lang="<?php echo e(config('app.locale')); ?>"
  class="light-style layout-navbar-fixed layout-menu-fixed layout-compact"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="<?php echo e(asset('assets')); ?>/"
  data-template="vertical-menu-template-no-customizer">

  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title><?php echo e($page_title); ?> | <?php echo e(config('app.name', 'Lensaudit')); ?></title>

    
    <meta name="description" content="" />
    <meta name="keywords" content="">
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('assets/img/favicon/favicon.ico')); ?>" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&ampdisplay=swap" rel="stylesheet">

    <!-- Icons -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/fonts/fontawesome.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/fonts/tabler-icons.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/fonts/flag-icons.css')); ?>" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/rtl/core.css" class="template-customizer-core-css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/rtl/theme-default.css" class="template-customizer-theme-css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/demo.css')); ?>" />
    
    <!-- Vendors CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/node-waves/node-waves.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/typeahead-js/typeahead.css')); ?>" /> 
    

    <!-- Page CSS -->
    
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/pages/app-invoice-print.css')); ?>" />

    <!-- Helpers -->
    <script src="<?php echo e(asset('assets/vendor/js/helpers.js')); ?>"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Template customizer: To hide customizer set displayCustomizer value false in config.js.  -->
    <script src="<?php echo e(asset('assets/vendor/js/template-customizer.js')); ?>"></script>
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="<?php echo e(asset('assets/js/config.js')); ?>"></script>
    
</head>

<body>

  <!-- Content -->

<div class="invoice-print p-5">

  <div class="d-flex justify-content-between flex-row">
    <div class="mb-4">
      <div class="d-flex svg-illustration mb-3 gap-2">
        <div class="app-brand-logo">
            <img src="http://127.0.0.1:5000/assets/svg/logo/logo.svg" alt="" class="h-auto " width="180px">
        </div>
      </div>
    </div>
    <div>
      <h4 class="fw-medium">#<?php echo e($users['data'][0]['invoice_id']); ?></h4>
      <div class="mb-2">
        <span class="text-muted">Date Issues:</span>
        <span class="fw-medium"><?php echo e($users['data'][0]['issued_date']); ?></span>
      </div>
      <div>
        <span class="text-muted">Date Due:</span>
        <span class="fw-medium"><?php echo e($users['data'][0]['due_date']); ?></span>
      </div>
    </div>
  </div>

  <hr />

  <div class="row d-flex justify-content-between mb-4">
    <div class="col-sm-6 w-50">
      <h6>Invoice To:</h6>
      <p class="mb-1"><?php echo e($users['data'][0]['company_id']); ?></p>
      <p class="mb-1"><?php echo e($users['data'][0]['company_name']); ?></p>
      <p class="mb-1"><?php echo e($users['data'][0]['company_number']); ?></p>
      <p class="mb-1"><?php echo e($users['data'][0]['company_email']); ?></p>
    </div>
    <div class="col-sm-6 w-50">
      <h6>Bank Details:</h6>
      <table>
        <tbody>
          <tr>
            <td class="pe-3">Bank Transation ID:</td>
            <td><?php echo e($users['data'][0]['bank_trans']); ?></td>
          </tr>
          <tr>
            <td class="pe-3">Bank Name:</td>
            <td><?php echo e($users['data'][0]['bank_name']); ?></td>
          </tr>
          <tr>
            <td class="pe-3">Country:</td>
            <td><?php echo e($users['data'][0]['bank_country']); ?></td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>

  <div class="table-responsive">
    <table class="table m-0">
      <thead class="table-light">
        <tr>
          <th>Item</th>
          <th>Description</th>
          <th>Cost</th>
          <th>Qty</th>
          <th>Price</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td><?php echo e($users['data'][0]['plan_name']); ?></td>
          <td><?php echo e($users['data'][0]['plan_desc']); ?></td>
          <td><?php echo e($users['data'][0]['plan_cost']); ?></td>
          <td>1</td>
          <td><?php echo e($users['data'][0]['plan_price']); ?></td>
        </tr>
        <tr>
        <td class="text-end px-4 py-4"></td>
        <td class="text-end px-4 py-4"></td>
          <td class="text-end px-4 py-3">
            <p class="mb-2">Subtotal:</p>
            <p class="mb-0">Total:</p>
          </td>
          <td class="px-4 py-3">
            <p class="fw-medium mb-2">$ <?php echo e($users['data'][0]['subtotal']); ?></p>
            <p class="fw-medium mb-0">$ <?php echo e($users['data'][0]['total']); ?></p>
          </td>
        </tr>
      </tbody>
    </table>
  </div>

  <div class="row">
    <div class="col-12">
      <span class="fw-medium">Note:</span>
      <span>It was a pleasure working with you and your team. We hope you will keep us in mind for future
        freelance projects. Thank You!</span>
    </div>
  </div>
</div>


<!-- / Content -->

  

  <!-- Core JS -->
  <!-- build:js assets/vendor/js/core.js -->
  
  <script src="<?php echo e(asset('assets/vendor/libs/jquery/jquery.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/popper/popper.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/js/bootstrap.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/node-waves/node-waves.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/hammer/hammer.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/i18n/i18n.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/typeahead-js/typeahead.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/js/menu.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/js/main.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/js/app-invoice-print.js')); ?>"></script>
  
</body>

</html>
<?php /**PATH /var/www/vhosts/leadaudits360.com/resources/views/pages/billing/download.blade.php ENDPATH**/ ?>