

<?php $__env->startSection('content'); ?>

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="py-3 mb-4">
       <span class="text-muted fw-light">Account Settings /</span> Account
    </h4>
    <?php if(session()->has('error')): ?>
              <div class="bg-danger bs-toast toast toast-placement-ex m-2 fade top-0 start-50 translate-middle-x show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-animation="true" data-bs-autohide="true" data-bs-delay="2000">
                <div class="toast-header" style="background-color: #f7f7f7 !important;">
                  <i class="ti ti-bell ti-xs me-2 text-danger"></i>
                  <div class="me-auto fw-medium">Error!</div>
                  <button type="button" class="btn-close text-white " data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
                <div class="toast-body text-white">
                  <?php echo session('error'); ?>

                </div>
              </div>
            <?php endif; ?>
            <?php if(session()->has('success')): ?>
              <div class="bg-success bs-toast toast toast-placement-ex m-2 fade top-0 start-50 translate-middle-x show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-animation="true" data-bs-autohide="true" data-bs-delay="2000">
                <div class="toast-header" style="background-color: #f7f7f7 !important;">
                  <i class="ti ti-bell ti-xs me-2 text-success"></i>
                  <div class="me-auto fw-medium">Success!</div>
                  
                  <button type="button" class="btn-close text-white " data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
                <div class="toast-body text-white">
                  <?php echo session('success'); ?>

                </div>
              </div>
            <?php endif; ?>
    <div class="row">
       <div class="col-md-12">
          <ul class="nav nav-pills flex-column flex-md-row mb-4">
             <li class="nav-item"><a class="nav-link active" href="<?php echo e(route('accounts')); ?>"><i class="ti-xs ti ti-users me-1"></i> Account</a></li>
             <?php if($profile['role'] != 1): ?><li class="nav-item"><a class="nav-link" href="<?php echo e(route('billing')); ?>"><i class="ti-xs ti ti-file-description me-1"></i> Billings</a></li><?php endif; ?>
             <li class="nav-item"><a class="nav-link" href="<?php echo e(route('notification')); ?>"><i class="ti-xs ti ti-bell me-1"></i> Notifications</a></li>
             <li class="nav-item"><a class="nav-link" href="<?php echo e(route('accountspassword')); ?>"><i class="ti-xs ti ti-key me-1"></i> Change Password</a></li>
          </ul>
          <div class="card mb-4">
             <h5 class="card-header">Profile Details</h5>
             <!-- Account -->
             <div class="card-body">
                <div class="d-flex align-items-start align-items-sm-center gap-4">
                   
                   <div class="avatar avatar-xl me-2">
                     <span class="avatar-initial rounded bg-label-info">
                        <?php
                           $str = $profile['full_name'];
                           $words = explode(' ', $str);
                           $result = $words[0][0]. $words[1][0];
                           echo $result;
                        ?>
                     </span>
                   </div>
                   <div class="button-wrapper">
                    <h5 class="mb-0"><?php echo e($profile['full_name']); ?></h5>
                    <h6 class="mb-1 text-muted"><?php echo e($profile['email']); ?></h6>
                    <h4 class="mb-1">+<?php echo e($profile['country_code']); ?> <?php echo e($profile['mobile_no']); ?></h4>
                   </div>
                </div>
             </div>
             <hr class="my-0">
             <div class="card-body">
               <form id="formAccountSettings" method="POST" action="<?php echo e(route('update_accounts')); ?>" class="fv-plugins-bootstrap5 fv-plugins-framework" novalidate="novalidate">
                  <?php echo csrf_field(); ?>
                  <input type="hidden" name="id" id="id" value="<?php echo e($profile['id']); ?>">
                  <div class="row">
                     <div class="col-6">
                        <div class="mb-3">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="first_name" name="first_name" placeholder="" aria-describedby="floatingInputHelp" value="<?php echo e($profile['first_name']); ?>"/>
                                <label for="first_name">First Name *</label>
                            </div>
                        </div>
                     </div>
                    <div class="col-6">
                        <div class="mb-3">
                           <div class="form-floating">
                              <input type="text" class="form-control" id="last_name" name="last_name" placeholder="" aria-describedby="floatingInputHelp" value="<?php echo e($profile['last_name']); ?>"/>
                              <label for="last_name">Last Name *</label>
                           </div>
                        </div>
                     </div>
                     <div class="col-6">
                        <div class="mb-3">
                           <div class="form-floating">
                              <input readonly type="text" class="form-control" id="email" name="email" placeholder="" aria-describedby="floatingInputHelp" value="<?php echo e($profile['email']); ?>"/>
                              <label for="email">Email Address *</label>
                           </div>
                        </div>
                     </div>
                     <div class="col-6">
                        <div class="mb-3">
                           <div class="input-group">
                               <span class="input-group-text">+<?php echo e($profile['country_code']); ?></span>
                               <div class="form-floating">
                                   <input type="text" id="mobile_no" name="mobile_no" class="form-control phone-number-mask" placeholder="202 555 0111" value="<?php echo e($profile['mobile_no']); ?>"/>
                                   <label for="mobile_no" >Phone Number *</label>
                               </div>
                             </div>
                         </div>
                     </div>
                  </div>
                  <div class="mt-2">
                     <button type="submit" class="btn btn-primary me-2 waves-effect waves-light">Save changes</button>
                     <button type="reset" class="btn btn-label-secondary waves-effect">Cancel</button>
                  </div>
               </form>
            </div>
          </div>
         <?php if($profile['role'] != 1): ?>
         <div class="card mb-4">
            <!-- Current Plan -->
            <h5 class="card-header">Current Plan</h5>
            <div class="card-body">
               <div class="row">
                  <div class="col-md-6 mb-1">
                     <div class="alert alert-dark mb-3" role="alert">
                        <h5 class="alert-heading mb-1">Your Current Plan is <?php echo e($profile['plan_actived']); ?></h5>
                        <span><?php echo e($profile['plan_description']); ?></span>
                     </div>
                  </div>
                  <div class="col-md-6 mb-1">
                     <div class="alert alert-warning mb-3" role="alert">
                        <h5 class="alert-heading mb-1">Active until 
                           <?php
                              $result = date('M d, Y',strtotime($profile['invoice_date']));
                              echo $result;
                           ?>
                        </h5>
                        <span>We will send you a notification upon Subscription expiration</span>
                     </div>
                  </div>
               </div>
            </div>
            <!-- /Current Plan -->
         </div>
         <?php endif; ?>
       </div>
    </div>
 </div>
 <!-- / Content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascripts'); ?>
<script src="<?php echo e(asset('assets/js/forms-extras.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/form-layouts.js')); ?>"></script>
<script>
   setTimeout(function() {
     $('.toast').hide();
   }, 6000);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/leadaudits360/resources/views/pages/profile/account.blade.php ENDPATH**/ ?>