<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Routing\Middleware\ThrottleRequests;
use App\Http\Controllers\Dashboard\PageController;
use App\Http\Controllers\Dashboard\LoginController;
use App\Http\Controllers\Dashboard\RegisterController;
use App\Http\Controllers\Dashboard\LogoutController;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Http\Controllers\Dashboard\CategoryController;
use App\Http\Controllers\Dashboard\UsersController;
use App\Http\Controllers\Dashboard\InvoiceController;
use App\Http\Controllers\Dashboard\RenewalController;
use App\Http\Controllers\Dashboard\ChecklistController;
use App\Http\Controllers\Dashboard\RolesController;
use App\Http\Controllers\Dashboard\FeedbackController;
use App\Http\Controllers\Dashboard\AuditorController;
use App\Http\Controllers\Dashboard\ScheduleController;
use App\Http\Controllers\Dashboard\SectionController;
use App\Http\Controllers\Dashboard\QuestionsController;
use App\Http\Controllers\Dashboard\CompanyController;
use App\Http\Controllers\Dashboard\LocationController;
use App\Http\Controllers\Dashboard\ResetController;
use App\Http\Controllers\Dashboard\ForgetController;
use App\Http\Controllers\Dashboard\AdminsController;
use App\Http\Controllers\Dashboard\ImagesController;
use App\Http\Controllers\Dashboard\ReportsController;
use App\Http\Controllers\Dashboard\BuilderController;
use App\Http\Controllers\Dashboard\TemplatesController;
use App\Http\Controllers\Dashboard\GatewayController;
use App\Http\Controllers\StripePaymentController;
use App\Http\Controllers\RazorpayPaymentController;

use App\Http\Controllers\Dashboard\AccountsController;
use App\Http\Controllers\Dashboard\PlansController;
use App\Http\Controllers\Dashboard\ResultController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
// Route::get('/', function () {
//     return view('main');
// });
Route::get('/', [LoginController::class, 'index'])->name('login');
Route::post('/login', [LoginController::class, 'loginpost'])->name('loginpost');
Route::get('/sign-up', [RegisterController::class, 'index'])->name('sign_up');
Route::post('/sign-up-api', [RegisterController::class, 'store'])->name('sign_up_api');
Route::get('/thank-you', [PageController::class, 'thankyou'])->name('thank_you');

Route::get('/privacy-policy', [PageController::class, 'privacypolicy'])->name('privacy_policy');
Route::get('/terms-and-conditions', [PageController::class, 'termsandconditions'])->name('terms_and_conditions');

Route::get('/forgot-password', [ForgetController::class, 'index'])->name('forgot_password');
Route::post('/forgot-password-mail', [ForgetController::class, 'store'])->name('forgot_mail');
Route::get('/reset-password', [ResetController::class, 'index'])->name('reset_password');
Route::post('/change-password', [ResetController::class, 'update'])->name('change_password');

Route::middleware(['auth'])->group(function () {
    Route::post('/logout', [LogoutController::class,'index'])->name('logouts');
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/subscription', [PageController::class, 'subscription'])->name('subscription');
    Route::get('/payment/{id}', [PageController::class, 'payment'])->name('payment');
    Route::get('stripe', [StripePaymentController::class, 'stripe'])->name('stripe');
    Route::post('stripe-post', [StripePaymentController::class, 'stripePost'])->name('stripe.post');
    Route::get('stripe-return', [StripePaymentController::class, 'stripeReturn'])->name('stripe.return');

    Route::get('razorpay-payment', [RazorpayPaymentController::class, 'index']);
    Route::post('razorpay-payment', [RazorpayPaymentController::class, 'store'])->name('razorpay.payment.store');

    
    // Admin
    Route::get('/users-management', [UsersController::class, 'index'])->name('users');
    Route::get('/users-management-api', [UsersController::class, 'list'])->name('users_api');
    Route::post('/update/users', [UsersController::class, 'update'])->name('update_users');
    Route::get('/detail/users/{id}', [UsersController::class, 'details'])->name('details_users');
    Route::get('/detail/users/{id}/company-department-api', [UsersController::class, 'company_department'])->name('details_users_department_api');
    Route::get('/detail/users/{id}/assignees-api', [UsersController::class, 'action_assignees'])->name('details_users_assignees_api');

    Route::get('/billing-and-invoicing', [InvoiceController::class, 'index'])->name('billing_and_invoicing');
    Route::get('/billing-and-invoicing-api', [InvoiceController::class, 'list'])->name('billing_and_invoicing_api');
    Route::get('/users/invoice/{id}', [InvoiceController::class, 'show'])->name('billing_and_invoicing_show');
    Route::get('/users/invoice-api/{id}', [InvoiceController::class, 'invoice_view'])->name('billing_and_invoicing_show_api');
    Route::get('/show/invoice/{id}', [InvoiceController::class, 'showinvoice'])->name('invoice_show');
    
    Route::get('/renewal-and-cancellation', [RenewalController::class, 'index'])->name('renewal_and_cancellation');
    Route::get('/renewal-and-cancellation-api', [RenewalController::class, 'list'])->name('renewal_and_cancellation_api');
    
    Route::get('/roles-and-hierarchy', [RolesController::class, 'index'])->name('roles');
    Route::get('/roles-and-hierarchy-api', [RolesController::class, 'list'])->name('roles_api');
    Route::post('/update/roles', [RolesController::class, 'update'])->name('update_roles');

    Route::get('/checklist', [ChecklistController::class, 'index'])->name('checklist');
    Route::get('/checklist-api', [ChecklistController::class, 'list'])->name('checklist_api');
    Route::get('/create/checklist', [ChecklistController::class, 'create'])->name('create_checklist');
    Route::post('/store/checklist', [ChecklistController::class, 'store'])->name('store_checklist');
    Route::post('/update/checklist', [ChecklistController::class, 'update'])->name('update_checklist');
    Route::get('/update/checklist/{id}', [ChecklistController::class, 'show'])->name('show_checklist');

    Route::get('/section/{id}', [SectionController::class, 'index'])->name('section');
    Route::get('/section-api/{id}', [SectionController::class, 'list'])->name('section_api');
    Route::get('/create/section/{id}', [SectionController::class, 'create'])->name('create_section');
    Route::post('/store/section', [SectionController::class, 'store'])->name('store_section');
    Route::post('/update/section', [SectionController::class, 'update'])->name('update_section');
    Route::get('/update/section/{id}', [SectionController::class, 'show'])->name('show_section');

    Route::get('/question/{id}', [QuestionsController::class, 'index'])->name('question');
    Route::get('/question-api/{id}', [QuestionsController::class, 'list'])->name('question_api');
    Route::get('/create/question/{id}', [QuestionsController::class, 'create'])->name('create_question');
    Route::post('/store/question', [QuestionsController::class, 'store'])->name('store_question');
    Route::post('/edit/question', [QuestionsController::class, 'edit'])->name('edit_question');
    Route::post('/update/question', [QuestionsController::class, 'update'])->name('update_question');
    Route::get('/update/question/{id}', [QuestionsController::class, 'show'])->name('show_question');

    Route::get('/category-management', [CategoryController::class, 'index'])->name('category');
    Route::get('/category-management-api', [CategoryController::class, 'list'])->name('category_api');
    Route::get('/category-checklist-management-api/{id}', [CategoryController::class, 'catcheck'])->name('catcheck_api');
    
    Route::get('/category/{id}/checklist', [CategoryController::class, 'catcheck_index'])->name('catcheck_index');
    
    Route::get('/create/category', [CategoryController::class, 'create'])->name('create_category');
    Route::post('/store/category', [CategoryController::class, 'store'])->name('store_category');
    Route::post('/update/category', [CategoryController::class, 'update'])->name('update_category');
    Route::get('/update/category/{id}', [CategoryController::class, 'show'])->name('show_category');
    
    
    Route::get('/plans', [PlansController::class, 'index'])->name('plans');
    Route::get('/plans-api', [PlansController::class, 'list'])->name('plans_api');
    Route::post('/update/plans', [PlansController::class, 'update'])->name('update_plans');
    Route::get('/update/plans/{id}', [PlansController::class, 'show'])->name('show_plans');
    
    Route::get('/feedback', [FeedbackController::class, 'index'])->name('feedback');
    Route::get('/feedback-api', [FeedbackController::class, 'list'])->name('feedback_api');
    Route::get('/create/feedback', [FeedbackController::class, 'create'])->name('support');
    Route::post('/store/feedback', [FeedbackController::class, 'store'])->name('store_feedback');
    Route::post('/update/feedback', [FeedbackController::class, 'update'])->name('update_feedback');
    Route::get('/update/feedback/{id}', [FeedbackController::class, 'show'])->name('show_feedback');
    
    Route::middleware(['check.plan'])->group(function () {
    // company
    Route::get('/email-templates', [PageController::class, 'emailtemplates'])->name('email_templates');
    Route::get('/auditors-management', [PageController::class, 'auditors'])->name('auditors');
    Route::get('/create/auditors', [PageController::class, 'createauditors'])->name('create_auditors');
    Route::get('/update/auditors/{id}', [PageController::class, 'updateauditors'])->name('update_auditors');
    
    Route::get('/auditors-management/auditor-list', [AuditorController::class, 'auditor_list'])->name('auditor_list');
    Route::post('/auditors-management/add-auditor', [AuditorController::class, 'add_auditor'])->name('add_auditor');
    Route::post('/auditors-management/get-auditor/{id}', [AuditorController::class, 'get_auditor'])->name('get_auditor');
    Route::post('/auditors-management/update-auditor', [AuditorController::class, 'update_auditor'])->name('update_auditor');
    Route::get('/auditors-management/delete-auditor/{id}', [AuditorController::class, 'delete_auditor'])->name('delete_auditor');
    
    
    Route::get('/company-department', [PageController::class, 'companydepartment'])->name('company_department');
    Route::get('/create/company-department', [PageController::class, 'createcompanydepartment'])->name('create_company_department');
    Route::get('/update/company-department/{id}', [PageController::class, 'updatecompany'])->name('update_company');


    Route::get('/company-department/company-list', [CompanyController::class, 'company_list'])->name('company_list');
    Route::post('/company-department/add-company', [CompanyController::class, 'add_company'])->name('add_company');
    Route::post('/company-department/get-company/{id}', [CompanyController::class, 'get_company'])->name('get_company');
    Route::post('/company-department/update-company', [CompanyController::class, 'update_company'])->name('update_company');
    Route::get('/company-department/delete-company/{id}', [CompanyController::class, 'delete_company'])->name('delete_company');
   
  
  
    Route::get('/schedule', [PageController::class, 'schedule'])->name('schedule');
    Route::get('/create/schedule', [PageController::class, 'createschedule'])->name('create_schedule');
    
    Route::get('/schedule/schedule-list', [ScheduleController::class, 'schedule_list'])->name('schedule_list');
    Route::post('/schedule/add-schedule', [ScheduleController::class, 'add_schedule'])->name('add_schedule');
    Route::post('/schedule/get-schedule/{id}', [ScheduleController::class, 'get_schedule'])->name('get_schedule');
    Route::post('/schedule/update-schedule', [ScheduleController::class, 'update_schedule'])->name('update_schedule');
    Route::get('/schedule/delete-schedule/{id}', [ScheduleController::class, 'delete_schedule'])->name('delete_schedule');
    
    
    Route::get('/locations', [PageController::class, 'locations'])->name('locations');
    Route::get('/create/locations', [PageController::class, 'createlocations'])->name('create_locations');
    Route::get('/update/location/{id}', [PageController::class, 'updatelocation'])->name('update_location');


    Route::get('/locations/location-list', [LocationController::class, 'location_list'])->name('location_list');
    Route::post('/locations/add-location', [LocationController::class, 'add_location'])->name('add_location');
    Route::post('/locations/get-location/{id}', [LocationController::class, 'get_location'])->name('get_location');
    Route::post('/locations/update-location', [LocationController::class, 'update_location'])->name('update_location');
    Route::get('/locations/delete-location/{id}', [LocationController::class, 'delete_location'])->name('delete_location');
  
  
    Route::get('/checklists', [PageController::class, 'checklists'])->name('checklists');
    Route::get('/create/checklists', [BuilderController::class, 'createchecklists'])->name('create_checklists');
    
    Route::get('/admins-management', [AdminsController::class, 'index'])->name('admins');
    Route::get('/admins-management-api', [AdminsController::class, 'list'])->name('admins_api');
    Route::get('/create/admins', [AdminsController::class, 'create'])->name('create_admins');
    Route::post('/store/admins', [AdminsController::class, 'store'])->name('store_admins');
    Route::post('/update/admins', [AdminsController::class, 'update'])->name('update_admins');
    Route::post('/delete/admins', [AdminsController::class, 'delete'])->name('delete_admins');
    Route::get('/update/admins/{id}', [AdminsController::class, 'show'])->name('show_admins');

    Route::get('/images', [ImagesController::class, 'index'])->name('gallery');
    Route::get('/images-api', [ImagesController::class, 'list'])->name('gallery_api');
    Route::get('/show/images/{audit_id}', [ImagesController::class, 'show'])->name('gallery_show');

    Route::get('/reports', [ReportsController::class, 'index'])->name('reports');
    Route::get('/reports-api', [ReportsController::class, 'list'])->name('reports_api');
    Route::get('/print/reports/{audit_id}', [ReportsController::class, 'print'])->name('print_reports');
    Route::post('/update/reports', [ReportsController::class, 'update'])->name('update_reports');

    Route::get('/form-builder', [BuilderController::class, 'index'])->name('formbuilder');
    Route::post('/store/form-builder', [BuilderController::class, 'store'])->name('store_builder');

    Route::get('/templates', [TemplatesController::class, 'index'])->name('templates');
    Route::post('/create/templates', [TemplatesController::class, 'store'])->name('create_department');
    
    // Route::get('/check-user', [PageController::class, 'dayscount'])->name('checkuser');

    Route::get('/payment-gateway', [PageController::class, 'gateway'])->name('gateway');
    Route::get('/update/payment-gateway/{id}', [PageController::class, 'updategateway'])->name('update_gateway');

    Route::get('/gateway/gateway-list', [GatewayController::class, 'gateway_list'])->name('gateway_list');
    Route::post('/gateway/get-gateway/{id}', [GatewayController::class, 'get_gateway'])->name('get_gateway');
    Route::post('/gateway/update-gateway', [GatewayController::class, 'update_gateway'])->name('update_gateway');
    
    Route::get('/accounts', [AccountsController::class, 'accounts'])->name('accounts');
    Route::post('/update/accounts', [AccountsController::class, 'update'])->name('update_accounts');
    Route::get('/change/password', [AccountsController::class, 'accountspassword'])->name('accountspassword');
    Route::post('/update/account-password', [AccountsController::class, 'updatepassword'])->name('update_accountspassword');
    
    Route::get('/billings', [AccountsController::class, 'billing'])->name('billing');
    Route::get('/billings-api', [AccountsController::class, 'billing_api'])->name('billing_api');
    Route::get('/notifications', [AccountsController::class, 'notification'])->name('notification');
    Route::get('/notifications-api', [AccountsController::class, 'notification_api'])->name('notification_api');

    Route::get('/results', [ResultController::class, 'index'])->name('results');
    Route::get('/results-api', [ResultController::class, 'list'])->name('results_api');
    Route::get('/create/results', [ResultController::class, 'create'])->name('create_results');
    Route::post('/store/results', [ResultController::class, 'store'])->name('store_results');
    Route::post('/update/results', [ResultController::class, 'update'])->name('update_results');
    Route::get('/update/results/{id}', [ResultController::class, 'show'])->name('show_results');
    Route::post('/delete/results', [ResultController::class, 'delete'])->name('delete_results');

    });
});

