<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Auth\AuthController;
use App\Http\Controllers\Api\Profile\PasswordController;
use App\Http\Controllers\Api\Profile\DashboardController;
use App\Http\Controllers\Api\Profile\ScheduleController;
use App\Http\Controllers\Api\Profile\ActionsController;
use App\Http\Controllers\Api\Profile\QuestionController;
use App\Http\Controllers\Api\Profile\NotificationController;
use App\Http\Controllers\Api\Profile\UserProfileController;
use App\Http\Controllers\Api\Profile\AuditsController;

use App\Http\Controllers\Api\Web\WebDashboardController;
use App\Http\Controllers\Api\Web\WebCateogryController;
use App\Http\Controllers\Api\Web\WebAuditorsController;
use App\Http\Controllers\Api\Web\WebScheduleController;
use App\Http\Controllers\Api\Web\WebUsersController;
use App\Http\Controllers\Api\Web\WebInvoiceController;
use App\Http\Controllers\Api\Web\WebRenewalController;
use App\Http\Controllers\Api\Web\WebRolesController;
use App\Http\Controllers\Api\Web\WebChecklistController;
use App\Http\Controllers\Api\Web\WebFeedbackController;
use App\Http\Controllers\Api\Web\WebDepartmentController;
use App\Http\Controllers\Api\Web\WebLocationsController;
use App\Http\Controllers\Api\Web\WebSectionController;
use App\Http\Controllers\Api\Web\WebQuestionsController;
use App\Http\Controllers\Api\Web\WebAdminsController;
use App\Http\Controllers\Api\Web\WebImagereportController;
use App\Http\Controllers\Api\Web\WebReportsController;
use App\Http\Controllers\Api\Web\WebPlanController;
use App\Http\Controllers\Api\Web\WebGatewayController;

use App\Http\Controllers\Api\Web\WebPlansController;
use App\Http\Controllers\Api\Web\WebAccountsController;
use App\Http\Controllers\Api\Web\WebResultController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('auth/register', [AuthController::class, 'register']);
Route::post('auth/login', [AuthController::class, 'login']);
Route::post('auth/loginweb', [AuthController::class, 'loginweb']);

Route::post('auth/dayscount', [AuthController::class, 'dayscount']);

Route::post('auth/forget', [AuthController::class, 'forgetApp']);
Route::post('auth/reset', [AuthController::class, 'resetApp']);
Route::post('auth/change-password', [AuthController::class, 'changepasswordApp']);
Route::post('auth/web/forget', [AuthController::class, 'forget']);
Route::post('auth/web/reset', [AuthController::class, 'reset']);
Route::post('auth/web/change-password', [AuthController::class, 'changepassword']);

Route::middleware(['auth'])->group(function(){
    Route::post('logout', [AuthController::class, 'logout']);
    Route::post('change-password', [PasswordController::class, 'changeUserPassword']);
    Route::post('dashboard', [DashboardController::class, 'userdata']);
    Route::post('audits', [ScheduleController::class, 'list']);
    Route::post('reschedule', [ScheduleController::class, 'update']);
    Route::post('questionnaire', [QuestionController::class, 'list']);
    Route::post('action', [ActionsController::class, 'list']);
    Route::post('generate-report', [ActionsController::class, 'generatereport']);
    Route::post('scores', [ActionsController::class, 'scores']);
    
    Route::post('/update-user-profile', [UserProfileController::class, 'update']);
    
    Route::post('notifications', [NotificationController::class, 'list']);
    Route::post('read-notifications', [NotificationController::class, 'update']);
    Route::post('view-notifications', [NotificationController::class, 'show']);
    Route::post('push-notifications', [NotificationController::class, 'push']);
    Route::post('create/audits', [AuditsController::class, 'update']);
    Route::post('signature/audits', [AuditsController::class, 'signature']);

    // web
    Route::post('web/dashboard', [WebDashboardController::class, 'me']);
    Route::post('web/logout', [WebDashboardController::class, 'logout']);
    
    Route::post('web/category', [WebCateogryController::class, 'list']);
    Route::post('web/category/{id}/checklist', [WebCateogryController::class, 'checklist']);
    Route::post('web/create/category', [WebCateogryController::class, 'create']);
    Route::post('web/update/category', [WebCateogryController::class, 'update']);
    Route::post('web/show/category/{id}', [WebCateogryController::class, 'view']);

    Route::post('web/auditor', [WebAuditorsController::class, 'list']);
    Route::post('web/create/auditor', [WebAuditorsController::class, 'create']);
    Route::post('web/update/auditor', [WebAuditorsController::class, 'update']);
    Route::post('web/show/auditor/{id}', [WebAuditorsController::class, 'view']);
    Route::post('web/delete/auditor/{id}', [WebAuditorsController::class, 'delete']);

    Route::post('web/schedule', [WebScheduleController::class, 'list']);
    Route::post('web/create/schedule', [WebScheduleController::class, 'create']);
    Route::post('web/update/schedule', [WebScheduleController::class, 'update']);
    Route::post('web/delete/schedule/{id}', [WebScheduleController::class, 'delete']);

    Route::post('web/users', [WebUsersController::class, 'list']);
    Route::post('web/update/users', [WebUsersController::class, 'update']);
    Route::post('web/detail/users/{id}', [WebUsersController::class, 'detail']);

    Route::post('web/invoice', [WebInvoiceController::class, 'list']);
    Route::post('web/view/invoice/{id}', [WebInvoiceController::class, 'view']);
    Route::post('web/print/invoice/{id}', [WebInvoiceController::class, 'prints']);
    Route::post('web/update/invoice', [WebInvoiceController::class, 'update']);

    Route::post('web/renewal', [WebRenewalController::class, 'list']);
    Route::post('web/update/renewal', [WebRenewalController::class, 'update']);
    Route::post('web/roles', [WebRolesController::class, 'list']);
    Route::post('web/update/roles', [WebRolesController::class, 'update']);

    Route::post('web/checklist', [WebChecklistController::class, 'list']);
    Route::post('web/checklist_template', [WebChecklistController::class, 'list_template']);
    Route::post('web/create/checklist', [WebChecklistController::class, 'create']);
    Route::post('web/update/checklist', [WebChecklistController::class, 'update']);
    Route::post('web/show/checklist/{id}', [WebChecklistController::class, 'view']);
    
    Route::post('web/section', [WebSectionController::class, 'list']);
    Route::post('web/create/section', [WebSectionController::class, 'create']);
    Route::post('web/update/section', [WebSectionController::class, 'update']);
    Route::post('web/show/section/{id}', [WebSectionController::class, 'view']);
    
    Route::post('web/questions', [WebQuestionsController::class, 'list']);
    Route::post('web/create/questions', [WebQuestionsController::class, 'create']);
    Route::post('web/update/questions', [WebQuestionsController::class, 'update']);
    Route::post('web/edit/questions', [WebQuestionsController::class, 'edit']);
    Route::post('web/show/questions/{id}', [WebQuestionsController::class, 'view']);
    
    Route::post('web/feedback', [WebFeedbackController::class, 'list']);
    Route::post('web/create/feedback', [WebFeedbackController::class, 'create']);
    Route::post('web/update/feedback', [WebFeedbackController::class, 'update']);
    Route::post('web/show/feedback/{id}', [WebFeedbackController::class, 'view']);

    Route::post('web/department', [WebDepartmentController::class, 'list']);
    Route::post('web/create/department', [WebDepartmentController::class, 'create']);
    Route::post('web/update/department', [WebDepartmentController::class, 'update']);
    Route::post('web/show/department/{id}', [WebDepartmentController::class, 'view']);
    Route::post('web/delete/department/{id}', [WebDepartmentController::class, 'delete']);


    Route::post('web/locations', [WebLocationsController::class, 'list']);
    Route::post('web/create/locations', [WebLocationsController::class, 'create']);
    Route::post('web/update/locations', [WebLocationsController::class, 'update']);
    Route::post('web/show/locations/{id}', [WebLocationsController::class, 'view']);
    Route::post('web/delete/locations/{id}', [WebLocationsController::class, 'delete']);
    
    Route::post('web/admins', [WebAdminsController::class, 'list']);
    Route::post('web/create/admins', [WebAdminsController::class, 'create']);
    Route::post('web/update/admins', [WebAdminsController::class, 'update']);
    Route::post('web/show/admins/{id}', [WebAdminsController::class, 'view']);
    Route::post('web/delete/admins', [WebAdminsController::class, 'delete']);
    
    Route::post('web/imagereport', [WebImagereportController::class, 'list']);
    Route::post('web/show/imagereport/{audit_id}', [WebImagereportController::class, 'view']);

    Route::post('web/reports', [WebReportsController::class, 'list']);
    Route::post('web/print/reports/{audit_id}', [WebReportsController::class, 'print']);
    Route::post('web/update/reports', [WebReportsController::class, 'update']);
    
    Route::post('web/plan', [WebPlanController::class, 'list']);
    Route::post('web/plan/{id}', [WebPlanController::class, 'view']);

    Route::post('web/gateway', [WebGatewayController::class, 'list']);
    Route::post('web/show/gateway/{id}', [WebGatewayController::class, 'view']);
    Route::post('web/update/gateway', [WebGatewayController::class, 'update']);
    
    Route::post('web/plans', [WebPlansController::class, 'list']);
    Route::post('web/update/plans', [WebPlansController::class, 'update']);
    Route::post('web/show/plans/{id}', [WebPlansController::class, 'view']);

    Route::post('web/account', [WebAccountsController::class, 'list']);
    Route::post('web/update/account', [WebAccountsController::class, 'update']);

    Route::post('web/results', [WebResultController::class, 'list']);
    Route::post('web/create/results', [WebResultController::class, 'create']);
    Route::post('web/update/results', [WebResultController::class, 'update']);
    Route::post('web/show/results/{id}', [WebResultController::class, 'view']);
    Route::post('web/delete/results', [WebResultController::class, 'delete']);
});