@extends('main')

@section('content')
        <div class="container flex-grow-1 container-p-y">
            <div class="card mb-4">
                <h5 class="card-header">Create Schedule</h5>
                <div class="card-body">
                    <form id="scheduleForm" method="post" enctype="multipart/form-data">
                            @csrf
                        <div class="row">
                        <div class="col-6 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select id="company_id" name="company_id" class="selectpicker w-100" data-style="btn-default">
                                    <option value="">Select Company</option>
                                    @if(!empty($companies['data']['department_list']))
                                    @foreach($companies['data']['department_list'] as $company)
                                    <option value="{{ $company['id'] }}">{{ $company['company_name'] }}</option>
                                    @endforeach
                                    @endif
                                </select>
                                    {{-- <span id="company_idError" class="error"></span> --}}
                            </div>
                            <div class="col-6 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select id="checklist_id" name="checklist_id" class="selectpicker w-100" data-style="btn-default">
                                    <option value="">Select Checklist</option>
                                    @if(!empty($checklists['data']['checklist']))
                                    @foreach($checklists['data']['checklist'] as $checklist)
                                    <option value="{{ $checklist['id'] }}">{{ $checklist['title'] }}</option>
                                    @endforeach
                                    @endif
                                </select>
                                  <span id="checklist_idError" class="error"></span>
                            </div>
                            <div class="col-6 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select id="location_id" name="location_id" class="selectpicker w-100" data-style="btn-default">
                                    <option value="">Select Locations</option>
                                    @if(!empty($locations['data']['locations_list']))
                                    @foreach($locations['data']['locations_list'] as $location)
                                    <option value="{{ $location['id'] }}">{{ $location['location'] }}</option>
                                    @endforeach
                                    @endif
                                </select>
                               <span id="location_idError" class="error"></span>
                            </div>
                            <div class="col-6 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select id="auditor_id" name="auditor_id" class="selectpicker w-100" data-style="btn-default">
                                    <option value="">Select Auditor</option>
                                    @if(!empty($auditors['data']['Auditors']))
                                    @foreach($auditors['data']['Auditors'] as $auditor)
                                    <option value="{{ $auditor['id'] }}">{{ $auditor['full_name'] }}</option>
                                    @endforeach
                                    @endif
                                </select>
                                <span id="auditor_idError" class="error"></span>
                            </div>
                            <hr>
                            <div class="col-12">
                                <label>Select Date & Time</label>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-floating">
                                    <input type="date" class="form-control" id="schedule_on" name="schedule_on" placeholder="" aria-describedby="floatingInputHelp" />
                                    <label for="schedule_on">Select Date</label>
                                </div>
                                  <span id="schedule_onError" class="error"></span>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="time" class="form-control" id="start_time" name="start_time" placeholder="" aria-describedby="floatingInputHelp" />
                                    <label for="floatingInput">Start Time</label>
                                </div>
                                  <span id="start_timeError" class="error"></span>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="time" class="form-control" id="end_time" name="end_time" placeholder="" aria-describedby="floatingInputHelp" />
                                    <label for="floatingInput">End Time</label>
                                </div>
                                 <span id="end_timeError" class="error"></span>
                            </div>
                            
                            <div class="col-12">
                                <button id="schedule_submit" type="button"  class="btn btn-primary me-sm-3 me-1 waves-effect waves-light">Submit</button>
                                <a href="{{ url()->previous() }}" class="btn btn-label-secondary waves-effect">Cancel</a>
                            </div>
                        </div>
                    </form>
                    
                </div>
            </div>
        </div>
@endsection

@section('javascripts')
<script src="{{ asset('assets/js/forms-file-upload.js')}}"></script>
<script>
    document.addEventListener('DOMContentLoaded', function (e) {

const formAddNewRecord = document.getElementById('scheduleForm');

if (!formAddNewRecord) {
    console.error('Form not found!');
    return;
}

// Form validation for Add new record
fv = FormValidation.formValidation(formAddNewRecord, {
    fields: {
        company_id: {
            validators: {
                notEmpty: {
                    message: 'Company is required'
                }
            }
        },
        checklist_id: {
            validators: {
                notEmpty: {
                    message: 'Checklist is required'
                }
            }
        },
        location_id: {
            validators: {
                notEmpty: {
                    message: 'Location is required'
                }
            }
        },
        auditor_id: {
            validators: {
                notEmpty: {
                    message: 'Auditor is required'
                }
            }
        },
        schedule_on: {
            validators: {
                notEmpty: {
                    message: 'Schedule date is required'
                }
            }
        },
        start_time: {
            validators: {
                notEmpty: {
                    message: 'Start time is required'
                }
            }
        },
        end_time: {
            validators: {
                notEmpty: {
                    message: 'End time is required'
                }
            }
        }
    },
    plugins: {
        trigger: new FormValidation.plugins.Trigger(),
        bootstrap5: new FormValidation.plugins.Bootstrap5({
            rowSelector: '.col-6, .col-12'
        }),
        submitButton: new FormValidation.plugins.SubmitButton(),
        autoFocus: new FormValidation.plugins.AutoFocus()
    },
    init: instance => {
        instance.on('plugins.message.placed', function (e) {
            if (e.element.parentElement.classList.contains('form-floating')) {
                e.element.parentElement.insertAdjacentElement('afterend', e.messageElement);
            }
        });
    }
});

$('#schedule_submit').click(function() {
                fv.validate().then(function(status) {
                    if (status === 'Valid') {
                        var addScheduleRoute = '{{ route('add_schedule') }}';
                        var form = document.getElementById("scheduleForm");

                        fetch(addScheduleRoute, {
                            method: 'POST',
                            body: new FormData(form),
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.status==true) {
                                Swal.fire({
                                    title: "Created",
                                    text: data.message,
                                    icon: "success",
                                    confirmButtonText: "OK",
                                });
                                setTimeout(function() {
                                    window.location.href = '/schedule'; // Replace with your redirect URL
                                }, 2000); 
                            } else {
                                alert('An error occurred. Please try again.');
                            }
                        })
                        .catch(error => {
                            alert('Failed to add company. Please try again.');
                            console.error('Error:', error);
                        });
                    }
                });
            });

    });
</script>


@endsection