@extends('main')

@section('content')
        <div class="container flex-grow-1 container-p-y">
            <div class="card mb-4">
                <h5 class="card-header">Create Checklist</h5>
                @if(session()->has('error'))
                <div class="bg-danger bs-toast toast toast-placement-ex m-2 fade top-0 start-50 translate-middle-x show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-animation="true" data-bs-autohide="true" data-bs-delay="2000">
                  <div class="toast-header" style="background-color: #f7f7f7 !important;">
                    <i class="ti ti-bell ti-xs me-2 text-danger"></i>
                    <div class="me-auto fw-medium">Error!</div>
                    <button type="button" class="btn-close text-white " data-bs-dismiss="toast" aria-label="Close"></button>
                  </div>
                  <div class="toast-body text-white">
                    {!! session('error') !!}
                  </div>
                </div>
                @endif
                @if(session()->has('success'))
                  <div class="bg-success bs-toast toast toast-placement-ex m-2 fade top-0 start-50 translate-middle-x show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-animation="true" data-bs-autohide="true" data-bs-delay="2000">
                    <div class="toast-header" style="background-color: #f7f7f7 !important;">
                      <i class="ti ti-bell ti-xs me-2 text-success"></i>
                      <div class="me-auto fw-medium">Success!</div>
                      {{-- <small class="text-muted">11 mins ago</small> --}}
                      <button type="button" class="btn-close text-white " data-bs-dismiss="toast" aria-label="Close"></button>
                    </div>
                    <div class="toast-body text-white">
                      {!! session('success') !!}
                    </div>
                  </div>
                @endif
                <div class="card-body">
                    <form action="{{ route('update_results') }}" method="POST" id="formValidation">
                        @csrf
                        <input type="hidden" name="id" id="id" value="{{$id}}">
                        <div class="row">
                            <div class="col-8 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select id="selectpickerBasic" class="selectpicker w-100" data-style="btn-default" id="checklist_id" name="checklist_id">
                                    <option value="">Select Category</option>
                                    @foreach ($category['data']['checklist'] as $user)
                                    <option value="{{ $user['id'] }}" @if($user['id'] == $checklist_view[0]['checklist_id']) selected @endif>{{ $user['title'] }}</option>
                                    @endforeach
                                </select>
                                <span class="errors"></span>
                            </div>
                            <div class="col-4 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select id="selectpickerBasic" class="selectpicker w-100" data-style="btn-default" id="status" name="status">
                                    <option value="">Select Status</option>
                                    <option value="1" @if('1' == $checklist_view[0]['status']) selected @endif>Active</option>
                                    <option value="2" @if('2' == $checklist_view[0]['status']) selected @endif>Inactive</option>
                                </select>
                                <span class="errors"></span>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="name" name="name" placeholder="" value="{{ $checklist_view[0]['name'] }}" aria-describedby="floatingInputHelp" />
                                    <label for="floatingInput">Message</label>
                                </div>
                                <span class="errors"></span>
                            </div>
                            <div class="col-4 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="symbols" name="symbols" placeholder="" aria-describedby="floatingInputHelp" value="{{ $checklist_view[0]['symbols'] }}"/>
                                    <label for="floatingInput">Symbols</label>
                                </div>
                                <span class="errors"></span>
                            </div>
                            <div class="col-4 mb-3">
                                <div class="form-floating">
                                    <input type="tel" class="form-control" id="percentage" name="percentage" placeholder="" aria-describedby="floatingInputHelp" value="{{ $checklist_view[0]['percentage'] }}"/>
                                    <label for="floatingInput">Percentage</label>
                                </div>
                                <span class="errors"></span>
                            </div>
                            <div class="col-4 mb-3">
                                <div class="form-floating">
                                    <input type="color" class="form-control" id="color" name="color" placeholder="" aria-describedby="floatingInputHelp" value="{{ $checklist_view[0]['color'] }}"/>
                                    <label for="floatingInput">Color</label>
                                </div>
                                <span class="errors"></span>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary me-sm-3 me-1 waves-effect waves-light">Submit</button>
                                <a href="{{ url()->previous() }}" class="btn btn-label-secondary waves-effect">Cancel</a>
                            </div>
                        </div>
                    </form>
                    
                </div>
            </div>
        </div>
@endsection

@section('javascripts')
<script src="{{ asset('assets/js/forms-file-upload.js')}}"></script>
<script>
  setTimeout(function() {
    $('.toast').hide();
  }, 6000);
</script>
<script>
'use strict';
const formAuthentication = document.querySelector('#formValidation');

document.addEventListener('DOMContentLoaded', function (e) {
  (function () {
    // Form validation for Add new record
    if (formAuthentication) {
      const fv = FormValidation.formValidation(formAuthentication, {
        fields: {
          'category_id': {
            validators: {
              notEmpty: {
                message: 'Please select category.'
              }
            }
          },
          'name': {
            validators: {
              notEmpty: {
                message: 'Please enter name.'
              }
            }
          },
          'status': {
            validators: {
              notEmpty: {
                message: 'Please select status.'
              }
            }
          }
        },
        plugins: {
          trigger: new FormValidation.plugins.Trigger(),
          bootstrap5: new FormValidation.plugins.Bootstrap5({
            eleValidClass: '',
            rowSelector: '.mb-3'
          }),
          submitButton: new FormValidation.plugins.SubmitButton(),

          defaultSubmit: new FormValidation.plugins.DefaultSubmit(),
          autoFocus: new FormValidation.plugins.AutoFocus()
        },
        init: instance => {
          instance.on('plugins.message.placed', function (e) {
            // if (e.element.parentElement.classList.contains('input-group')) {
              e.element.parentElement.insertAdjacentElement('afterend', e.messageElement);
            // }
          });
        }
      });
    }
  })();
});

</script>
@endsection