{{-- <!DOCTYPE html>
<html
   lang="{{config('app.locale')}}"
   class="light-style layout-navbar-fixed layout-menu-fixed layout-compact"
   dir="ltr"
   data-theme="theme-default"
   data-assets-path="{{ asset('assets')}}/"
   data-template="vertical-menu-template-no-customizer">
   <head>
      <meta charset="utf-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
      <title>{{ $page_title }} | {{config('app.name', 'Lensaudit')}}</title>
      <meta name="description" content="" />
      <meta name="keywords" content="">
      <link rel="icon" type="image/x-icon" href="{{ asset('assets/img/favicon/favicon.ico')}}" />
      <link rel="preconnect" href="https://fonts.googleapis.com">
      <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
      <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&ampdisplay=swap" rel="stylesheet">
      <link rel="stylesheet" href="{{ asset('assets/vendor/fonts/fontawesome.css')}}" />
      <link rel="stylesheet" href="{{ asset('assets/vendor/fonts/tabler-icons.css')}}"/>
      <link rel="stylesheet" href="{{ asset('assets/vendor/fonts/flag-icons.css')}}" />
      <link rel="stylesheet" href="{{ asset('assets/vendor/css/rtl/core.css" class="template-customizer-core-css')}}" />
      <link rel="stylesheet" href="{{ asset('assets/vendor/css/rtl/theme-default.css" class="template-customizer-theme-css')}}" />
      <link rel="stylesheet" href="{{ asset('assets/css/demo.css')}}" />
      <link rel="stylesheet" href="{{ asset('assets/vendor/libs/node-waves/node-waves.css')}}" />
      <link rel="stylesheet" href="{{ asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css')}}" />
      <link rel="stylesheet" href="{{ asset('assets/vendor/libs/typeahead-js/typeahead.css')}}" />
      <link rel="stylesheet" href="{{ asset('assets/vendor/css/pages/app-invoice-print.css')}}" />
      <script src="{{ asset('assets/vendor/js/helpers.js')}}"></script>
      <script src="{{ asset('assets/vendor/js/template-customizer.js')}}"></script>
      <script src="{{ asset('assets/js/config.js')}}"></script>
      <style>
         .invoice-print{
         min-width: 768px !important;
         font-size: 17px !important;
         }
         .invoice-print * {
         color: #353535 !important;
         }
         table, th, td {
         border: 1px solid #353535;
         border-collapse: collapse;
         }
         .table p{
         text-transform:none !important;
         font-weight: 600;
         font-size: 15px !important;
         }
         .table .table-light th {
         font-weight: 600;
         font-size: 15px !important;
         }
      </style>
   </head>
   <body>
      <div class="invoice-print p-2">
         <div class="row">
            <div class="col-4 mb-5">
               <div class="avatar avatar-xl me-2" style="width: 6.5rem;height: 6.5rem;">
                  <span class="avatar-initial rounded bg-label-info">
                  <?php
                     $str = $data['company_name'];
                     $words = explode(' ', $str);
                     $result = $words[0][0];
                     echo $result;
                     ?>
                  </span>
               </div>
            </div>
            <div class="col-12 mb-3">
               <h1 class="mb-0">Inspection</h1>
            </div>
            <div class="col-12 mb-1">
               <table class="table table-bordered m-0">
                  <thead class="table-light">
                     <tr>
                        <th>
                           <h6 class="mb-0">{{$data['total_answer']}}/{{$data['total_question']}} 
                              <?php
                                 $total_question = $data['total_question'];
                                 $total_ques_answered = $data['total_answer'];
                                 $percent_total = $total_ques_answered / $total_question * 100;
                                 $percent = round($percent_total, 0);
                                 echo $percent.'%';
                                 ?>
                           </h6>
                           <strong>Score</strong>
                        </th>
                        <th>
                           <h6 class="mb-0">{{ $data['submitted_by_name'] }}</h6>
                           <strong>Conducted by</strong>
                        </th>
                        <th>
                           <h6 class="mb-0">
                              @if($data['status']== '0')
                              In Progress
                              @endif
                              @if($data['status']== '1')
                              In Review
                              @endif
                              @if($data['status']== '2')
                              Completed
                              @endif
                              @if($data['status']== '3')
                              Rejected
                              @endif
                           </h6>
                           <strong>Status</strong>
                        </th>
                     </tr>
                  </thead>
               </table>
            </div>
            <div class="col-12 mb-5">
               <table class="table table-bordered-black">
                  <tbody>
                     <tr>
                        <th class="col-6">
                           <h6 class="mb-0"><strong>Audit ID</strong></h6>
                        </th>
                        <th class="col-6">
                           <p class="mb-0">#{{ $data['report_id'] }}</p>
                        </th>
                     </tr>
                     <tr>
                        <th class="col-6">
                           <h6 class="mb-0"><strong>Company Name</strong></h6>
                        </th>
                        <th class="col-6">
                           <p class="mb-0">{{ $data['company_name'] }}</p>
                        </th>
                     </tr>
                     <tr>
                        <th class="col-6">
                           <h6 class="mb-0"><strong>Conducted on</strong></h6>
                        </th>
                        <th class="col-6">
                           <p class="mb-0">{{ $data['date'] }}</p>
                        </th>
                     </tr>
                     <tr>
                        <th class="col-6">
                           <h6 class="mb-0"><strong>Location</strong></h6>
                        </th>
                        <th class="col-6">
                           <p class="mb-0">{{ $data['location'] }}</p>
                        </th>
                     </tr>
                  </tbody>
               </table>
            </div>
            <div class="col-12 mt-3 mb-5">
               <div class="row">
                  <div class="col-12">
                     <div class="card table-responsive shadow-none bg-transparent border border-secondary p-0 mb-5">
                        <table class="table m-0">
                           <thead class="table-light">
                              <tr>
                                 <th colspan="4">
                                    <h5 class="mb-0"><strong>Overview</strong></h5>
                                 </th>
                              </tr>
                              <tr>
                                 <th>Section</th>
                                 <th>Answered</th>
                                 <th>Question</th>
                                 <th>%</th>
                              </tr>
                           </thead>
                           <tbody>
                              @for($ia = 0; $ia < count($data['section']); $ia++)
                              <tr>
                                 <td>{{$data['section'][$ia]['section_name']}}</td>
                                 <td>{{$data['section'][$ia]['section_total_answer']}}</td>
                                 <td>{{$data['section'][$ia]['section_total_question']}}</td>
                                 <td>
                                    <?php
                                       $total_question = $data['section'][$ia]['section_total_question'];
                                       $total_ques_answered = $data['section'][$ia]['section_total_answer'];
                                       
                                       if($total_question != 0){
                                         $percent_total = $total_ques_answered / $total_question * 100;
                                         $percent = round($percent_total, 0);
                                         echo $percent.'%';
                                       }else{
                                         $percent = 0;
                                         echo $percent.'%';
                                       }
                                       ?>
                                 </td>
                              </tr>
                              @endfor
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
            @for($ia = 0; $ia < count($data['section']); $ia++)
            <div class="col-12 mb-2">
               <div class="row">
                  <div class="col-12">
                     <div class="card table-responsive shadow-none bg-transparent border border-secondary p-0 mb-5">
                        <table class="table m-0">
                           <thead class="table-light">
                              <tr class="table-dark">
                                 <th colspan="4">
                                    <h5 class="mb-0"><strong style="color: #ffffff !important">{{$data['section'][$ia]['section_name']}}</strong></h5>
                                 </th>
                              </tr>
                              <tr>
                                 <th>#</th>
                                 <th>Question</th>
                                 <th>RESPONSE</th>
                              </tr>
                           </thead>
                           <tbody>
                              @if($data['section'][$ia]['section_question'] != null)
                              @for($aa = 0; $aa < count($data['section'][$ia]['section_question']); $aa++)
                              <tr>
                                 <td>{{$data['section'][$ia]['section_question'][$aa]['questions_id']}}</td>
                                 <td>{{$data['section'][$ia]['section_question'][$aa]['title']}}</td>
                                 <td>{{$data['section'][$ia]['section_question'][$aa]['questions_answer']}}</td>
                              </tr>
                              @if(!empty($data['section'][$ia]['section_question'][$aa]['questions_comment']))
                              <tr>
                                 <td colspan="3">
                                    <h6 class="mb-0">Comment</h6>
                                    <p class="mb-0">{{$data['section'][$ia]['section_question'][$aa]['questions_comment']}}</p>
                                 </td>
                              </tr>
                              @endif
                              @if(!empty($data['section'][$ia]['section_question'][$aa]['questions_image']))
                              <tr>
                                 <td colspan="3">
                                    <h6 class="mb-2">Images</h6>
                                    <div class="row">
                                       @for($im = 0; $im < count($data['section'][$ia]['section_question'][$aa]['questions_image']); $im++)
                                       <div class="col-3 mb-3">
                                          <div class="card">
                                             <img class="card-img-top" src="{{ $data['question_image'] }}{{ $data['section'][$ia]['section_question'][$aa]['questions_image'][$im] }}" alt="{{$im}}"> 
                                          </div>
                                       </div>
                                       @endfor
                                    </div>
                                 </td>
                              </tr>
                              @endif
                              @endfor
                              @endif
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
            @endfor
            <div class="col-12">
               <div class="row">
                  <div class="col-12">
                     <div class="card border rounded">
                        <div class="card-body bg-primary">
                           <h5 class="card-title mb-0" style="color: #ffffff !important">Declaration</h5>
                        </div>
                        <div class="card-body">
                           <img class="card-img-top w-20" src="{{ $data['signature_image'] }}" alt="{{$data['submitted_by_name']}}"> 
                           <hr>
                           <span>({{$data['submitted_by_name']}})</span>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <script src="{{ asset('assets/vendor/libs/jquery/jquery.js')}}"></script>
      <script src="{{ asset('assets/vendor/libs/popper/popper.js')}}"></script>
      <script src="{{ asset('assets/vendor/js/bootstrap.js')}}"></script>
      <script src="{{ asset('assets/vendor/libs/node-waves/node-waves.js')}}"></script>
      <script src="{{ asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js')}}"></script>
      <script src="{{ asset('assets/vendor/libs/hammer/hammer.js')}}"></script>
      <script src="{{ asset('assets/vendor/libs/i18n/i18n.js')}}"></script>
      <script src="{{ asset('assets/vendor/libs/typeahead-js/typeahead.js')}}"></script>
      <script src="{{ asset('assets/vendor/js/menu.js')}}"></script>
      <script src="{{ asset('assets/js/main.js')}}"></script>
      <script src="{{ asset('assets/js/app-invoice-print.js')}}"></script>
   </body>
</html> --}}

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>{{ $data['report_id'] }} | {{config('app.name', 'Lensaudit')}} | {{ $page_title }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
  <style>
    .page-break {
        page-break-after: always;
    }
    @page {
        margin: 60px;
        border: 1px solid #adadad;
        border-radius: 5px;
    }
    .border{
        border: 2.5px solid #c5c6c6;
        background-color: #fff;
        border-radius: 15px;
        padding: 10px;
        margin: 0 10px;
    }
    .border-score{
        border: 2.5px solid #c5c6c6;
        background-color: #fff;
        border-radius: 15px;
        padding: 10px;
        margin: 0 10px;
    }
    .border-score img{
        width: 100%;
        border-radius: 100%;
        border: 2px solid #c5c6c6;
    }
    .list-element img{
        width: 100%;
        border-radius: 100%;
        border: 2px solid #c5c6c6;
    }
    .top-space{
        margin-top: 20px;
    }
    body{
      /* font-size: 16px; */
      /* font-family: "Montserrat", sans-serif; */
      font-family: "Poppins", serif;
      font-style: normal;
      font-weight: 400 !important;
      color: #353535 !important;
    }
    h1{
      font-size: 2em;
    }
    h2{
      font-size: 1.5em;
    }
    h1,h2,h3,h4,h5,h6{
      font-weight: 500 !important;
    }
    section{
      margin: 30px;
    }
    table, th, td{
      /* border-radius: 5px; */
    }
    .score table, th, td {
      /* border: 1px solid; */
      text-align: left;
      border-spacing: 4px;
    }
    .score th, td {
        border: 1px solid #adadad;
        padding: 5px 15px;
    }
    .font-14{
      font-size: 14px;
    }
    .font-15{
      font-size: 15px;
    }
    .font-16{
      font-size: 16px;
    }
    .text-slim{
      font-weight: 400 !important;
    }
    .text-normal{
      font-weight: 500 !important;
    }
    .text-bold{
      font-weight: 600 !important;
    }
    .text-uppercase{
      text-transform: uppercase;
    }
    .info{
      background-color: #00cfe8 !important;
      color: #ffffff !important;
      border-color: #00cfe8 !important;
    }
    .warning{
      background-color: #ff9f43 !important;
      color: #ffffff !important;
      border-color: #ff9f43 !important;
    }
    .danger{
      background-color: #ea5455 !important;
      color: #ffffff !important;
      border-color: #ea5455 !important;
    }
    .success{
      background-color: #28c76f !important;
      color: #ffffff !important;
      border-color: #28c76f !important;
    }
    .secondary{
      background-color: #c0c0c0 !important;
      color: #ffffff !important;
      border-color: #c0c0c0 !important;
    }
    .auditor{
      padding: 4px;
    }
    .auditor table, th, td {
      border: 1px solid #adadad;
      border-collapse: collapse;
      padding: 15px;
    }
    .overview{
      padding: 4px;
    }
    .overview table, th {
      border: 1px solid #adadad;
      border-collapse: collapse;
      padding: 15px;
    }
    .overview table thead th{
      font-weight: 600 !important;
    }
    .overview table tbody td{
      font-weight: 400 !important;
      padding: 8px 15px;
      border: 1px solid #adadad;
    }
    .light{
      background: #dddddd;
    }
    .dark{
      background: #979797;
      color: #fff;
    }
    .mb{
      margin-bottom: 20px;
    }
    .col {
      flex: 0 0 auto;
      width: 19%;
    }
    .mr{
      margin-right: 10px;
    }
    .declaration{
      padding: 4px;
    }
    .declaration table, th {
      border: 1px solid #adadad;
      border-collapse: collapse;
      padding: 15px;
    }
    .declaration table thead th{
      font-weight: 600 !important;
    }
    .declaration table tbody td{
      font-weight: 400 !important;
      padding: 8px 15px;
      border: 0px solid #adadad;
    }
    .avatar .avatar-initial {
      position: relative;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      text-transform: uppercase;
      display: flex;
      align-items: center;
      justify-content: center;
      color: #fff;
      background-color: #c9c8ce;
      font-weight: 500;
      width: 120px;
      height: 120px;
      border-radius: 10px;
   }
  </style>

</head>
<body>
  <section>
    <div style="padding: 0 4px">
      {{-- <img src="https://www.socialtitli.com/assets/images/logo.png" alt="" width="180px"><br>
      <h1 style="margin-top: 10px !important;">SPARC Checklist 3.0 2025</h1> --}}
      <div class="avatar avatar-xl me-2" style="width: 120px;height: 120px;margin-bottom: 20px">
         <h1><span class="avatar-initial rounded bg-label-info">
         <?php
            $str = $data['company_name'];
            $words = explode(' ', $str);
            $result = $words[0][0];
            echo $result;
         ?>
         </span></h1>
      </div>
    </div>
    <div class="score mb">
      <table style="width: 100%;">
        <tbody>
          <tr>
            <th style="width: 30%;">
               <span class="text-bold text-uppercase">Audit ID</span><br>
               <span class="text-slim font-14">#{{$data['report_id']}}</span>
            </th>
            @php
               $statuses = [
                  '0' => ['label' => 'In Progress', 'class' => 'warning'],
                  '1' => ['label' => 'In Review', 'class' => 'info'],
                  '2' => ['label' => 'Completed', 'class' => 'success'],
                  '3' => ['label' => 'Rejected', 'class' => 'danger'],
               ];
            @endphp
            {{-- @php
               $total_question = $data['total_question'] ?? 0;
               $total_ques_answered = $data['total_answer'] ?? 0;
               $percent = ($total_question > 0) ? round(($total_ques_answered / $total_question) * 100, 0) : 0;

               foreach ($data['results'] as $results){
                  if ($percent $results['symbols'] $results['percentage']) {
                     $color = $results['color'];
                  }
               }
               
            @endphp --}}
            @php
               $total_question = $data['total_question'] ?? 0;
               $total_ques_answered = $data['total_answer'] ?? 0;
               $percent = ($total_question > 0) ? round(($total_ques_answered / $total_question) * 100, 0) : 0;

               // dd($data['results']['percentage']);
               foreach ($data['results'] as $results) {
                  $percentage = (int)$results['percentage'];
                  
                  if (
                     (round($percent) == $percentage)
                  ) {
                     $symbol = $results['symbols'];
                     $color = $results['color'];
                     $message = $results['name'];
                  }
               }
            @endphp
            <th class="{{ $statuses[$data['status']]['class'] }}" style="width: 30%;">
               <span class="text-bold text-uppercase">Status</span><br>
               <span class="text-slim font-14">
                  {{ $statuses[$data['status']]['label'] }}
               </span>
            </th>
            <th style="width: 40%;background-color: {{ $color }};border-color: {{ $color }};color:white !important;">
               <span class="text-bold text-uppercase">Result</span><br>
               <span class="text-slim font-14">{{$message}} ( {{$symbol}} {{ $percent }}%)</span>
            </th>
          </tr>
        </tbody>
      </table>
    </div>
    <div class="auditor mb">
      <table style="width: 100%;">
        <tbody>
          <tr>
            <th class="text-bold text-uppercase" style="width: 40%;">Score</th>
            <th class="text-slim" style="width: 60%;">{{$data['total_answer'] * 100}}/{{$data['total_question'] * 100}} {{ $percent }}%</th>
          </tr>
          <tr>
            <th class="text-bold text-uppercase" style="width: 40%;">Conducted by</th>
            <th class="text-slim" style="width: 60%;">{{ $data['submitted_by_name'] }}</th>
          </tr>
          <tr>
            <th class="text-bold text-uppercase" style="width: 40%;">Company Name</th>
            <th class="text-slim" style="width: 60%;">{{$data['company_name']}}</th>
          </tr>
          <tr>
            <th class="text-bold text-uppercase" style="width: 40%;">Conducted on</th>
            <th class="text-slim" style="width: 60%;">{{ $data['date'] }}</th>
          </tr>
          <tr>
            <th class="text-bold text-uppercase" style="width: 40%;">Location</th>
            <th class="text-slim" style="width: 60%;">{{ $data['location'] }}</th>
          </tr>
        </tbody>
      </table>
    </div>
    <div class="overview">
      <table width="100%">
         <thead>
            <tr class="dark">
               <th colspan="5" style="font-size: 18px">Overview</th>
               {{-- <th>1,375 / 1,625 (0%)</th> --}}
            </tr>
            <tr class="light">
               <th width="56%">Section</th>
               <th width="10%">Questions</th>
               <th width="10%">Answered</th>
               <th colspan="2" width="24%">Score</th>
            </tr>
         </thead>
         <tbody>
            @foreach ($data['section'] as $section)
               @php
                  $total_question = $section['section_total_question'] ?? 0;
                  $total_ques_answered = $section['section_total_answer'] ?? 0;
                  $percent = ($total_question > 0) ? round(($total_ques_answered / $total_question) * 100, 0) : 0;

                  // Assign colors based on percentage range
                  if ($percent <= 25) {
                        $color = 'danger'; // Red
                  } elseif ($percent <= 50) {
                        $color = 'warning'; // Yellow
                  } elseif ($percent <= 75) {
                        $color = 'info'; // Blue
                  } else {
                        $color = 'success'; // Green
                  }
               @endphp

               <tr>
                  <td>{{ $section['section_name'] }}</td>
                  <td>{{ $section['section_total_answer'] }}</td>
                  <td>{{ $section['section_total_question'] }}</td>
                  <td>{{ $section['section_total_answer'] *100 }} / {{ $section['section_total_question'] *100 }}</td>
                  <td class="{{ $color }}">{{ $percent }}%</td>
               </tr>
            @endforeach
         </tbody>
      </table>
    </div>
  </section>
  <div class="page-break"></div>
  <section>
   <div class="overview mb">
      {{-- @foreach ($data['section'] as $section)
         <table width="100%" class="mb">
            <thead>
                  <tr class="dark">
                     <th style="font-size: 18px">{{ $section['section_name'] }}</th>
                     <th>
                        <span class="text-bold text-uppercase font-14">Score</span><br>
                        <span class="text-slim font-14">
                              {{ $section['section_total_answer'] * 100 }}/{{ $section['section_total_question'] * 100 }}
                        </span>
                     </th>
                  </tr>
                  <tr class="light">
                     <th width="85%">Questions</th>
                     <th width="15%">Response</th>
                  </tr>
            </thead>
            <tbody>
                  @if (!empty($section['section_question']))
                     @foreach ($section['section_question'] as $question)
                        <tr>
                              <td>{{ $question['title'] }}</td>
                              <td class="success">{{ $question['questions_answer'] }}</td>
                        </tr>

                        @if (!empty($question['questions_comment']))
                              <tr>
                                 <td colspan="2">
                                    <span class="font-15 text-bold">Comment</span><br>
                                    <span class="font-14 text-slim">{{ $question['questions_comment'] }}</span>
                                 </td>
                              </tr>
                        @endif

                        @if (!empty($question['questions_image']))
                              <tr>
                                 <td colspan="2">
                                    <span class="font-15 text-bold">Images</span><br>
                                    <div style="display: flex; margin-top: 8px;">
                                          @foreach ($question['questions_image'] as $index => $image)
                                             <div class="col mr">
                                                <img src="{{ $data['question_image'] . $image }}" 
                                                      alt="Image {{ $index }}" 
                                                      style="border-radius: 5px; width: 100%; border: 1px solid #dddddd;">
                                             </div>
                                          @endforeach
                                    </div>
                                 </td>
                              </tr>
                        @endif
                     @endforeach
                  @endif
            </tbody>
         </table>
      @endforeach --}}

      @foreach ($data['section'] as $section)
         <table width="100%" class="mb">
            <thead>
                  <tr class="dark">
                     <th style="font-size: 18px">{{ $section['section_name'] }}</th>
                     <th>
                        <span class="text-bold text-uppercase font-14">Score</span><br>
                        <span class="text-slim font-14">
                              {{ $section['section_total_answer'] * 100 }}/{{ $section['section_total_question'] * 100 }}
                        </span>
                     </th>
                  </tr>
                  <tr class="light">
                     <th width="85%">Questions</th>
                     <th width="15%">Response</th>
                  </tr>
            </thead>
            <tbody>
                  @if (!empty($section['section_question']))
                     @foreach ($section['section_question'] as $question)
                        @php
                              // Assign colors based on the response
                              $response = strtolower($question['questions_answer'] ?? '');
                              if (in_array($response, ['yes', 'correct'])) {
                                 $color = 'success';
                              } elseif (in_array($response, ['partial', 'maybe'])) {
                                 $color = 'warning';
                              } elseif (in_array($response, ['no', 'incorrect'])) {
                                 $color = 'danger'; 
                              } else {
                                 $color = 'secondary';
                              }
                        @endphp

                        <tr>
                              <td>{{ $question['title'] }}</td>
                              <td class="{{ $color }}">{{ $question['questions_answer'] }}</td>
                        </tr>

                        @if (!empty($question['questions_comment']))
                              <tr>
                                 <td colspan="2">
                                    <span class="font-15 text-bold">Comment</span><br>
                                    <span class="font-14 text-slim">{{ $question['questions_comment'] }}</span>
                                 </td>
                              </tr>
                        @endif

                        @if (!empty($question['questions_image']))
                              <tr>
                                 <td colspan="2">
                                    <span class="font-15 text-bold">Images</span><br>
                                    <div style="display: flex; margin-top: 8px;">
                                          @foreach ($question['questions_image'] as $index => $image)
                                             <div class="col mr">
                                                <img src="{{ $data['question_image'] . $image }}" 
                                                      alt="Image {{ $index }}" 
                                                      style="border-radius: 5px; width: 100%; border: 1px solid #dddddd;">
                                             </div>
                                          @endforeach
                                    </div>
                                 </td>
                              </tr>
                        @endif
                     @endforeach
                  @endif
            </tbody>
         </table>
      @endforeach
   </div>
   <div class="declaration mb">
      <table width="100%" style="padding: 0 15px;border: 0px;">
         <tr>
            <th width="50%" style="padding: 0 15px 0 0;border: 0px;">
               <table width="100%">
                  <thead>
                     <tr class="dark">
                        <th colspan="2" style="font-size: 18px">Confirmed by</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td width="40%">
                           <div>
                              <img src="{{ $data['signature_image'] }}" alt="" width="100%">
                           </div>
                        </td>
                        <td width="60%" style="vertical-align: text-top;">
                           <div>
                              <small><b>#AU-31E27</b></small><br>
                              <span>{{$data['submitted_by_name']}}</span><br>
                              <span>{{$data['date']}}</span>
                           </div>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </th>
            <th width="50%" style="padding: 0 15px 0 0;border: 0px;"></th>
            {{-- <th width="50%" style="padding: 0 0 0 15px;border: 0px;">
               <table width="100%">
                  <thead>
                     <tr class="dark">
                        <th colspan="2" style="font-size: 18px">Approved by</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td width="40%">
                           <div>
                              <img src="https://app.leadaudits360.com/storage/app/signature/SI-2234S/SI-2234S_sign_1729237965.png" alt="" width="100%">
                           </div>
                        </td>
                        <td width="60%" style="vertical-align: text-top;">
                           <div>
                              <small><b>#AU-31E27</b></small><br>
                              <span>Pavan Poojari</span><br>
                              <span>2024-10-20 13:22:12</span>
                           </div>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </th> --}}
         </tr>
         
      </table>
   </div>
  </section>
</body>
</html>