@extends('main')

@section('content')
<style>
  .form-wrap.form-builder .frmb .sortable-options input[type=text] {
    width: calc(30% - 17px);
    margin: 0 3px;
    float: none;
}
</style>
        <div class="container flex-grow-1 container-p-y">
            <div class="card mb-4">
                <h5 class="card-header">Update Question</h5>
                @if(session()->has('error'))
                <div class="bg-danger bs-toast toast toast-placement-ex m-2 fade top-0 start-50 translate-middle-x show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-animation="true" data-bs-autohide="true" data-bs-delay="2000">
                  <div class="toast-header" style="background-color: #f7f7f7 !important;">
                    <i class="ti ti-bell ti-xs me-2 text-danger"></i>
                    <div class="me-auto fw-medium">Error!</div>
                    <button type="button" class="btn-close text-white " data-bs-dismiss="toast" aria-label="Close"></button>
                  </div>
                  <div class="toast-body text-white">
                    {!! session('error') !!}
                  </div>
                </div>
                @endif
                @if(session()->has('success'))
                  <div class="bg-success bs-toast toast toast-placement-ex m-2 fade top-0 start-50 translate-middle-x show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-animation="true" data-bs-autohide="true" data-bs-delay="2000">
                    <div class="toast-header" style="background-color: #f7f7f7 !important;">
                      <i class="ti ti-bell ti-xs me-2 text-success"></i>
                      <div class="me-auto fw-medium">Success!</div>
                      {{-- <small class="text-muted">11 mins ago</small> --}}
                      <button type="button" class="btn-close text-white " data-bs-dismiss="toast" aria-label="Close"></button>
                    </div>
                    <div class="toast-body text-white">
                      {!! session('success') !!}
                    </div>
                  </div>
                @endif
                <div class="card-body">
                    <form action="{{ route('edit_question') }}" method="POST">
                        @csrf
                        <input type="hidden" type="text" name="id" id="id" value="{{$id}}">
                         <input type="hidden" name="checklist_id" id="checklist_id" value="{{$checklist_view[0]['checklist_id']}}">
                        
                        <div class="row">
                            <div class="col-6 mb-3">
                                <select id="selectpickerBasic" class="selectpicker w-100" data-style="btn-default" id="type" name="type">
                                    <option value="">Select Type</option>
                                    <option value="radio-group" @if('radio-group' == $checklist_view[0]['type']) selected @endif>Radio Group</option>
                                    <option value="checkbox-group" @if('checkbox-group' == $checklist_view[0]['type']) selected @endif>Checkbox Group</option>
                                </select>
                            </div>
                            <div class="col-6 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select id="selectpickerBasic" class="selectpicker w-100" data-style="btn-default" id="status" name="status">
                                    <option value="">Select Status</option>
                                    <option value="1" @if('1' == $checklist_view[0]['status']) selected @endif>Active</option>
                                    <option value="2" @if('2' == $checklist_view[0]['status']) selected @endif>Inactive</option>
                                </select>
                                <span class="errors"></span>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="build-wrap" id="fb-editor"></div>
                                <input type="hidden" id="admin_message" name="admin_message" class="admin_message" value="[{!! json_encode($checklist_view[0]['option_array']) !!}]">
                            </div>
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary me-sm-3 me-1 waves-effect waves-light">Submit</button>
                                <a href="{{ url()->previous() }}" class="btn btn-label-secondary waves-effect">Cancel</a>
                            </div>
                        </div>
                    </form>
                    
                </div>
            </div>
        </div>
@endsection

@section('javascripts')
<script src="{{ asset('assets/js/forms-file-upload.js')}}"></script>
<script src="{{ asset('assets/vendor/formBuilder/assets/js/vendor.js')}}"></script>
<script src="{{ asset('assets/vendor/formBuilder/assets/js/form-builder.min.js')}}"></script>
<script src="{{ asset('assets/vendor/formBuilder/assets/js/form-render.min.js')}}"></script>
<style>
  .build-wrap ul li{
    margin-left: 0px !important;
  }
  .build-wrap ul{
    padding-right: 0px !important;
  }
  .delete-confirm, .copy-button, .sort-button{
    display: none !important;
  }
  .form-wrap.form-builder .frmb .field-actions .btn{
    background-color: #166379 !important;
    color: #ffffff !important;
    border-radius: 5px;
  }
</style>
<script>
    jQuery(function($) {
  var fbTemplate = document.getElementById('fb-editor');
  
  var options = {
    formData: '[{!! json_encode($checklist_view[0]['option_array']) !!}]',
    disabledFieldButtons: ['remove']
    ,
    disableFields: [
      'autocomplete',
      'file',
      'date',
      'header',
      'number',
      'select',
      'hidden',
      'textarea',
      'button',
      'text',
      'section',
      'checkbox-group',
      'radio-group',
    ],
    showActionButtons: false
    // onAddOption: (optionTemplate, optionIndex) => {
    //   optionTemplate.label = `Option ${optionIndex.index + 1}`
    //   optionTemplate.value = `option-${optionIndex.index + 1}`
    //   optionTemplate.points = `value-${optionIndex.index + 1}`
    //   return optionTemplate
    // }

  };

  var formBuilder = $(fbTemplate).formBuilder(options);

  fbTemplate.addEventListener('mouseover', function(event) {
      var editor = formBuilder.actions.getData('json');
      // var editor = formBuilder.formData;
      var value = editor;
      var input = $('.admin_message');
      input.val(value);
  });
  document.addEventListener('fieldAdded', function(){
    var editor = formBuilder.formData;
    var value = editor;
    var input = $('#admin_message');
    input.val(value);
  });
});

</script>
<script>
    setTimeout(function() {
      $('.toast').hide();
    }, 6000);
  </script>
@endsection