@extends('main')

@section('content')

<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="py-3 mb-4">
       <span class="text-muted fw-light">Account Settings /</span> Change Password
    </h4>
    @if(session()->has('error'))
              <div class="bg-danger bs-toast toast toast-placement-ex m-2 fade top-0 start-50 translate-middle-x show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-animation="true" data-bs-autohide="true" data-bs-delay="2000">
                <div class="toast-header" style="background-color: #f7f7f7 !important;">
                  <i class="ti ti-bell ti-xs me-2 text-danger"></i>
                  <div class="me-auto fw-medium">Error!</div>
                  <button type="button" class="btn-close text-white " data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
                <div class="toast-body text-white">
                  {!! session('error') !!}
                </div>
              </div>
            @endif
            @if(session()->has('success'))
              <div class="bg-success bs-toast toast toast-placement-ex m-2 fade top-0 start-50 translate-middle-x show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-animation="true" data-bs-autohide="true" data-bs-delay="2000">
                <div class="toast-header" style="background-color: #f7f7f7 !important;">
                  <i class="ti ti-bell ti-xs me-2 text-success"></i>
                  <div class="me-auto fw-medium">Success!</div>
                  {{-- <small class="text-muted">11 mins ago</small> --}}
                  <button type="button" class="btn-close text-white " data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
                <div class="toast-body text-white">
                  {!! session('success') !!}
                </div>
              </div>
            @endif
    <div class="row">
       <div class="col-md-12">
          <ul class="nav nav-pills flex-column flex-md-row mb-4">
             <li class="nav-item"><a class="nav-link" href="{{ route('accounts') }}"><i class="ti-xs ti ti-users me-1"></i> Account</a></li>
             @if($profile['role'] != 1)<li class="nav-item"><a class="nav-link" href="{{ route('billing') }}"><i class="ti-xs ti ti-file-description me-1"></i> Billings</a></li>@endif
             <li class="nav-item"><a class="nav-link" href="{{ route('notification') }}"><i class="ti-xs ti ti-bell me-1"></i> Notifications</a></li>
             <li class="nav-item"><a class="nav-link active" href="{{ route('accountspassword') }}"><i class="ti-xs ti ti-key me-1"></i> Change Password</a></li>
          </ul>
          <div class="card mb-4">
             {{-- <h5 class="card-header">Change Password</h5> --}}
             <!-- Account -->
             <div class="card-body">
                <div class="d-flex align-items-start align-items-sm-center gap-4">
                   {{-- <img src="../../assets/img/avatars/14.png" alt="user-avatar" class="d-block w-px-100 h-px-100 rounded" id="uploadedAvatar" /> --}}
                   <div class="avatar avatar-xl me-2">
                     <span class="avatar-initial rounded bg-label-info">
                        <?php
                           $str = $profile['full_name'];
                           $words = explode(' ', $str);
                           $result = $words[0][0]. $words[1][0];
                           echo $result;
                        ?>
                     </span>
                   </div>
                   <div class="button-wrapper">
                    <h5 class="mb-0">{{ $profile['full_name'] }}</h5>
                    <h6 class="mb-1 text-muted">{{ $profile['email'] }}</h6>
                    <h4 class="mb-1">+{{ $profile['country_code'] }} {{ $profile['mobile_no'] }}</h4>
                   </div>
                </div>
             </div>
             <hr class="my-0">
             <div class="card-body">
               <form id="formAuthentication" method="POST" action="{{ route('update_accountspassword') }}" >
                  @csrf
                        @method('POST')
                        <div class="row">
                           <div class="col-6">
                              <div class="mb-3 form-password-toggle">
                                 <div class="form-floating input-group input-group-merge">
                                   <input
                                     type="password"
                                     id="password"
                                     class="form-control"
                                     name="password"
                                     placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                     aria-describedby="password" />
                                     <label for="password" style="z-index: 10;">Password *</label>
                                   <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                                 </div>
                               </div>
                           </div>
                           
                            <div class="col-6">
                              <div class="mb-3 form-password-toggle">
                                 <div class="form-floating input-group input-group-merge">
                                   <input
                                     type="password"
                                     id="password_confirmation"
                                     class="form-control"
                                     name="password_confirmation"
                                     placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                     aria-describedby="password" />
                                     <label for="password_confirmation" style="z-index: 10;">Confirm Password *</label>
                                   <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                                 </div>
                               </div>
                            </div>
                            
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary me-sm-3 me-1 waves-effect waves-light">Submit</button>
                                <a href="{{ url()->previous() }}" class="btn btn-label-secondary waves-effect">Cancel</a>
                            </div>
                        </div>
               </form>
            </div>
          </div>
         
       </div>
    </div>
 </div>
 <!-- / Content -->
@endsection

@section('javascripts')
<script src="{{ asset('assets/js/forms-extras.js')}}"></script>
<script src="{{ asset('assets/js/form-layouts.js')}}"></script>
<script src="{{ asset('assets/js/form-validation.js')}}"></script>
<script src="{{ asset('assets/js/pages-auth2.js')}}"></script>
<script>
   setTimeout(function() {
     $('.toast').hide();
   }, 6000);
</script>
@endsection