@extends('main')

@section('content')
        <div class="container flex-grow-1 container-p-y">
            <div class="card mb-4">
                <h5 class="card-header">Update Plans</h5>
                @if(session()->has('error'))
                <div class="bg-danger bs-toast toast toast-placement-ex m-2 fade top-0 start-50 translate-middle-x show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-animation="true" data-bs-autohide="true" data-bs-delay="2000">
                  <div class="toast-header" style="background-color: #f7f7f7 !important;">
                    <i class="ti ti-bell ti-xs me-2 text-danger"></i>
                    <div class="me-auto fw-medium">Error!</div>
                    <button type="button" class="btn-close text-white " data-bs-dismiss="toast" aria-label="Close"></button>
                  </div>
                  <div class="toast-body text-white">
                    {!! session('error') !!}
                  </div>
                </div>
                @endif
                @if(session()->has('success'))
                  <div class="bg-success bs-toast toast toast-placement-ex m-2 fade top-0 start-50 translate-middle-x show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-animation="true" data-bs-autohide="true" data-bs-delay="2000">
                    <div class="toast-header" style="background-color: #f7f7f7 !important;">
                      <i class="ti ti-bell ti-xs me-2 text-success"></i>
                      <div class="me-auto fw-medium">Success!</div>
                      {{-- <small class="text-muted">11 mins ago</small> --}}
                      <button type="button" class="btn-close text-white " data-bs-dismiss="toast" aria-label="Close"></button>
                    </div>
                    <div class="toast-body text-white">
                      {!! session('success') !!}
                    </div>
                  </div>
                @endif
                <div class="card-body">
                    <form action="{{ route('update_plans') }}" method="POST">
                        @csrf
                        <input type="hidden" name="id" id="id" value="{{$id}}">
                        <div class="row">
                            <div class="col-6 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                @if($id == 1)<input type="hidden" value="{{ $plans_view['status'] }}" id="status" name="status">@endif
                                <select id="selectpickerBasic" @if($id == 1) disabled="true" @endif class="selectpicker w-100 h-100" data-style="btn-default" @if($id != 1) id="status" name="status" @endif>
                                    <option value="">Select Status</option>
                                    <option value="1" selected>Active</option>
                                    <option value="2">Inactive</option>
                                </select>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control"  placeholder="" aria-describedby="floatingInputHelp" id="title" name="title" value="{{ $plans_view['title'] }}"/>
                                    <label for="floatingInput">Name</label>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" @if($id == 1) readonly @endif class="form-control"  placeholder="" aria-describedby="floatingInputHelp" id="amount" name="amount" value="{{ $plans_view['amount'] }}"/>
                                    <label for="floatingInput">Amount</label>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control" placeholder="" aria-describedby="floatingInputHelp" id="days" name="days" value="{{ $plans_view['days'] }}"/>
                                    <label for="floatingInput">Days</label>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-floating">
                                    <textarea type="text" class="form-control" placeholder="" aria-describedby="floatingInputHelp" id="subtitle" name="subtitle" style="height: auto">{{ $plans_view['subtitle'] }}</textarea>
                                    <label for="floatingInput">Description</label>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-floating">
                                    <textarea type="text" class="form-control" placeholder="" aria-describedby="floatingInputHelp" id="feature" name="feature" style="height: auto">{{ $plans_view['feature'] }}</textarea>
                                    <label for="floatingInput">Feature</label>
                                </div>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary me-sm-3 me-1 waves-effect waves-light">Submit</button>
                                <a href="{{ url()->previous() }}" class="btn btn-label-secondary waves-effect">Cancel</a>
                            </div>
                        </div>
                    </form>
                    
                </div>
            </div>
        </div>
@endsection

@section('javascripts')
<script src="{{ asset('assets/js/forms-file-upload.js')}}"></script>

<script>
  setTimeout(function() {
    $('.toast').hide();
  }, 6000);
</script>
@endsection