@extends('main')
@section('content')

    <!-- Pricing Plans -->
    <section class="section-py first-section-pt mt-4">
        <div class="container">
          <h2 class="text-center mb-2">Subscription Plans</h2>
          <p class="text-center">
            Choose the plan that suits your needs and experience the effectiveness and ease-of-use of our software.
          </p>
  
          <div class="row mx-0 gy-3 px-lg-5 mt-4">

            @if(!empty($plans['data']['plan']))
            @foreach($plans['data']['plan'] as $plan)

            <div class="col-lg mb-md-0 mb-4">
                <div class="card border rounded shadow-none">
                  <div class="card-body">
                    <h3 class="card-title text-center text-capitalize mb-1">{{ $plan['title'] }}</h3>
                    <p class="text-center">{{ $plan['subtitle'] }}</p>
                    <div class="text-center">
                      <div class="d-flex justify-content-center">
                        <sup class="h6 pricing-currency mt-3 mb-0 me-1 text-primary">$</sup>
                        <h1 class="display-4 mb-0 text-primary">{{ $plan['amount'] }}</h1>
                        <sub class="h6 pricing-duration mt-auto mb-2 text-muted fw-normal">/month</sub>
                      </div>
                    </div>
    
                    {{-- <a href="payment-page.html" class="btn btn-label-success d-grid w-100">Your Current Plan</a>
                     --}}
                     @php
                     $encryptedId = Crypt::encrypt($plan['id']);
                     @endphp
                        {{-- @if($users['data']['profile']['plan_actived'] == $plan['id'])
                        <a href="#" class="btn btn-label-success d-grid w-100">Your Current Plan</a>
                        @elseif($plan['id'] == 1 && $users['data']['profile']['id'] != null)
                            <a href="start-trial.html" class="btn btn-primary d-grid w-100 disabled">Trial Plan</a>
                        @elseif($users['data']['profile']['id'] != null)
                            <a href="{{ route('payment', ['id' => $encryptedId]) }}" class="btn btn-primary d-grid w-100">Subscribe Now</a>
                        @endif --}}
                        {{-- working  --}}
                        {{-- @if($users['data']['profile']['plan_actived'] == $plan['id'])
                        @if(1 == $plan['id'])
                        <a href="#" class="btn btn-label-success d-grid w-100">Your Current Plan</a>
                        @else
                        <a href="{{ route('payment', ['id' => $encryptedId]) }}" class="btn btn-label-success d-grid w-100">Your Current Plan</a>
                        @endif
                        @elseif($plan['id'] == 1 && $users['data']['profile']['id'] != null)
                            <a href="start-trial.html" class="btn btn-primary d-grid w-100 disabled">Trial Plan</a>
                        @elseif($users['data']['profile']['id'] != null)
                            <a href="{{ route('payment', ['id' => $encryptedId]) }}" class="btn btn-primary d-grid w-100">Subscribe Now</a>
                        @endif --}}
                        @if($users['data']['profile']['plan_actived'] == $plan['id'])
                        @if(1 == $plan['id'])
                        <a href="#" class="btn btn-label-success d-grid w-100">Your Current Plan</a>
                        @else
                          @if($users['data']['profile']['days'] <= 7)
                          <a href="{{ route('payment', ['id' => $encryptedId]) }}" class="btn btn-label-success d-grid w-100">Your Current Plan</a>
                          @else 
                          <a href="#" class="btn btn-label-success d-grid w-100">Your Current Plan</a>
                          @endif
                        @endif
                        @elseif($plan['id'] == 1)
                            <a href="#" class="btn btn-primary d-grid w-100 disabled">Trial Plan</a>
                        @elseif($users['data']['profile']['id'] != null)
                            <a href="{{ route('payment', ['id' => $encryptedId]) }}" class="btn btn-primary d-grid w-100">Subscribe Now</a>
                        @endif
                  </div>
                </div>
            </div>

            @endforeach
            @endif          
  
          </div>
        </div>
      </section>

@endsection

@section('javascripts')
<script>
  @if(session('success'))
      Swal.fire({
          icon: "success",
          title: "{{ session('success') }}",
          // text: "An error occurred. Please try again later.",
      });
  @endif

  @if(session('error'))
      Swal.fire({
          title: 'Oops...',
          text: '{{ session('error') }}',
          icon: 'error',
          confirmButtonText: 'OK'
      });
  @endif
</script>
@endsection
