@extends('main')

@section('content')
@if(isset($plans['data']) && !empty($plans['data']['plan']))
<section class="section-py bg-body first-section-pt">
    <div class="container mt-2">
        <div class="card px-3" style="max-width: 600px; margin: auto;">
        <div class="row">
          <div class="col-lg-6 col-md-6 card-body">
            <h4 class="mb-2">Order Summary</h4>
            <p class="pb-2 mb-0">
                Review your order details and ensure everything is correct before completing your subscription.
            </p>
            <div class="bg-lighter p-4 rounded mt-4">
              <div class="d-flex align-items-center">
                <h1 class="text-heading display-5 mb-1">${{$plans['data']['plan'][0]['amount'] }}</h1>
                <sub>/month</sub>
              </div>
            </div>
            <div>
              <div class="d-flex justify-content-between align-items-center mt-3">
                <p class="mb-0">Subtotal</p>
                <h6 class="mb-0">${{$plans['data']['plan'][0]['amount'] }}</h6>
              </div>
              <hr />
              <div class="d-flex justify-content-between align-items-center mt-3 pb-1">
                <p class="mb-0">Total</p>
                <h6 class="mb-0">${{$plans['data']['plan'][0]['amount'] }}</h6>
              </div>
              <div class="d-grid mt-3">
                {{-- <button class="btn btn-success" id="proceed-btn">
                  <span class="me-2">Proceed with Payment</span>
                  <i class="ti ti-arrow-right scaleX-n1-rtl"></i>
                </button> --}}
                <form action="{{ route('razorpay.payment.store') }}" method="POST" >
                    @csrf
                    <script src="https://checkout.razorpay.com/v1/checkout.js"
                            {{-- data-key="{{ env('RAZORPAY_KEY') }}" --}}
                            data-key="{{$gateways['data']['gateway'][0]['key_value'] }}"
                            {{-- data-amount="{{ $plan->amount * 100 }}"
                            data-buttontext="Pay ${{ $plan->amount }}" --}}
                            data-amount="{{$plans['data']['plan'][0]['amount'] * 100}}"
                            data-currency="USD"
                            data-buttontext="Proceed with Payment"
                            data-name="leadaudits360"
                            data-description="Razorpay"
                            data-image="https://leadaudits360.com/assets/svg/logo/logo.svg"
                            data-prefill.name="name"
                            data-prefill.email="email"
                            data-theme.color="#055093">
                    </script>
                    <input type="hidden" name="id" value="{{ $id }}">
                </form>
              </div>
              

              <p class="mt-4 pt-2">
                By continuing, you accept to our Terms of Services and Privacy Policy. Please note that payments are
                non-refundable.
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
</section>



@else
<section class="section-py first-section-pt help-center-header position-relative overflow-hidden mt-4">
      <h3 class="text-center">No Plans Available</h3>
      <p class="text-center px-3 mb-0">Please select proper plan.</p>
</section>
@endif

@endsection


