@extends('main')
@section('content')
        <div class="container flex-grow-1 container-p-y">
            <div class="card mb-4">
                <h5 class="card-header">Update Payment Gateway</h5>
                <div class="card-body">
                    <form id="gatewayFormUpdate" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="key_value" name="key_value" placeholder="" aria-describedby="floatingInputHelp" value="{{ $gateway['data']['gateway'][0]['key_value'] }}" />
                                    <label for="floatingInput">Key</label>
                                    <span id="key_valueError" class="error"></span>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="secret_value" name="secret_value" placeholder="" aria-describedby="floatingInputHelp" value="{{ $gateway['data']['gateway'][0]['secret_value'] }}" />
                                    <label for="floatingInput">Secret</label>
                                    <span id="secret_valueError" class="error"></span>
                                </div>
                            </div>
            
                            <input type="hidden" class="form-control" placeholder="" aria-describedby="floatingInputHelp" id="id" name="id" value="{{ $gateway['data']['gateway'][0]['id'] }}"  />
                            
                            <div class="col-12">
                                <button id="gateway_update_submit" type="button" class="btn btn-primary me-sm-3 me-1 waves-effect waves-light">Submit</button>
                                <a href="{{ url()->previous() }}" class="btn btn-label-secondary waves-effect">Cancel</a>
                            </div>
                        </div>
                    </form>
                    
                </div>
            </div>
        </div>
@endsection

@section('javascripts')
<!-- <script src="{{ asset('assets/datatable/users-datatables.js')}}"></script> -->
<script src="{{ asset('assets/js/forms-file-upload.js')}}"></script>
<script>
    document.addEventListener('DOMContentLoaded', function (e) {
        

const formaddRecord = document.getElementById('gatewayFormUpdate');

if (!formaddRecord) {
    console.error('Form not found!');
    return;
}

// Form validation for Add new record
fv = FormValidation.formValidation(formaddRecord, {
    fields: {
        key_value: {
            validators: {
                notEmpty: {
                    message: 'Key is required'
                }
            }
        },
        secret_value: {
            validators: {
                notEmpty: {
                    message: 'Secret is required'
                }
            }
        },  
    },
    plugins: {
        trigger: new FormValidation.plugins.Trigger(),
        bootstrap5: new FormValidation.plugins.Bootstrap5({
            rowSelector: '.col-6, .col-12'
        }),
        submitButton: new FormValidation.plugins.SubmitButton(),
        autoFocus: new FormValidation.plugins.AutoFocus()
    },
    init: instance => {
        instance.on('plugins.message.placed', function (e) {
            if (e.element.parentElement.classList.contains('form-floating')) {
                e.element.parentElement.insertAdjacentElement('afterend', e.messageElement);
            }
        });
    }
});


$('#gateway_update_submit').click(function() {
                fv.validate().then(function(status) {
                    if (status === 'Valid') {
                        var updateGatewayRoute = '{{ route('update_gateway') }}';
                        var form = document.getElementById("gatewayFormUpdate");

                        fetch(updateGatewayRoute, {
                            method: 'POST',
                            body: new FormData(form),
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.status==true) {
                                Swal.fire({
                                    title: "Updated",
                                    text: data.message,
                                    icon: "success",
                                    confirmButtonText: "OK",
                                });
                                setTimeout(function() {
                                    window.location.href = '/payment-gateway';
                                }, 2000); 
                            } else {
                                alert('An error occurred. Please try again.');
                            }
                        })
                        .catch(error => {
                            alert('Failed to Update Key and secret. Please try again.');
                            console.error('Error:', error);
                        });
                    }
                });
            });
    
});
    
    </script>



@endsection