@extends('main')

@section('content')
        <div class="container-xxl flex-grow-1 container-p-y">
            <h4 class="py-3 mb-4"><span class="text-muted fw-light">Payment Gateway</span></h4>
            <!-- DataTable with Buttons -->
            <div class="card">
                <div class="card-datatable table-responsive pt-0">
                  <table class="datatables-basic table">
                    <thead>
                      <tr>
                        <th></th>
                        <th></th>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Key</th>
                        <th>Secret</th>
                        <th>Action</th>
                      </tr>
                    </thead>
                  </table>
                </div>
              </div>
            </div>
        </div>
@endsection

@section('javascripts')
<script src="{{ asset('assets/datatable/gateway-datatables.js')}}"></script>
<script>




  $(document).on('click', '.item-delete', function(e) {
    e.preventDefault();
    var deleteId = $(this).data('id');


    var deleteLocationRoute = '{{ route('delete_location', ['id' => ':id']) }}';
deleteLocationRoute = deleteLocationRoute.replace(':id', deleteId);


    console.log("delete _id"+deleteId);

    Swal.fire({
      title: "Are you sure?",
      text: "You won't be able to revert this!",
      icon: "warning",
      showCancelButton: false, // Remove the cancel button
      confirmButtonColor: "#d33",
      confirmButtonText: "Delete"
    }).then((result) => {
      if (result.isConfirmed) {

    

        $.ajax({
    url: deleteLocationRoute,
    type: 'GET',
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    // data: formData,
    success: function(response) {
  
      console.log(response);
  
      if (response.status){
  
        Swal.fire({
          title: "Deleted",
          text: "Record has been deleted successfully",
          icon: "success",
          confirmButtonText: "OK",
        }).then(() => {
          location.reload();
        });
  
  
        // Swal.fire({
        //   title: "Deleted", 
        //   text: "DSP/PTP has been deleted successfully", 
        //   type: "success"
        // },
        //     function(){ 
        //         location.reload();
        //     }
        // );
  
      
     
  
      }else if(response.errors){
  
        Swal.fire("Oops...", "Something went wrong!", "error");
  
      }
  
  
    },
    error: function(xhr, status, error) {
      // handle the error here
    }
  });
     
        
      }
    });
  });
</script>
@endsection