
@extends('main')

@section('content')
<style>
  .form-wrap.form-builder .frmb .sortable-options input[type=text] {
    width: calc(30% - 17px);
    margin: 0 3px;
    float: none;
}
</style>
        <div class="container flex-grow-1 container-p-y">
            <div class="card mb-4">
                <h5 class="card-header">Create Form</h5>
                @if(session()->has('error'))
                <div class="bg-danger bs-toast toast toast-placement-ex m-2 fade top-0 start-50 translate-middle-x show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-animation="true" data-bs-autohide="true" data-bs-delay="2000">
                  <div class="toast-header" style="background-color: #f7f7f7 !important;">
                    <i class="ti ti-bell ti-xs me-2 text-danger"></i>
                    <div class="me-auto fw-medium">Error!</div>
                    <button type="button" class="btn-close text-white " data-bs-dismiss="toast" aria-label="Close"></button>
                  </div>
                  <div class="toast-body text-white">
                    {!! session('error') !!}
                  </div>
                </div>
                @endif
                @if(session()->has('success'))
                  <div class="bg-success bs-toast toast toast-placement-ex m-2 fade top-0 start-50 translate-middle-x show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-animation="true" data-bs-autohide="true" data-bs-delay="2000">
                    <div class="toast-header" style="background-color: #f7f7f7 !important;">
                      <i class="ti ti-bell ti-xs me-2 text-success"></i>
                      <div class="me-auto fw-medium">Success!</div>
                      {{-- <small class="text-muted">11 mins ago</small> --}}
                      <button type="button" class="btn-close text-white " data-bs-dismiss="toast" aria-label="Close"></button>
                    </div>
                    <div class="toast-body text-white">
                      {!! session('success') !!}
                    </div>
                  </div>
                @endif
                <div class="card-body">
                    <form action="{{ route('store_builder') }}" method="POST" id="formValidation">
                        @csrf
                        <div class="mb-3">
                            <select id="selectpickerBasic" class="selectpicker w-100" data-style="btn-default" id="checklist_id" name="checklist_id">
                                <option value="">Select Checklist</option>
                                @foreach ($checklist['data'] as $check)
                                <option value="{{ $check['id'] }}">{{ $check['title'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="build-wrap" id="fb-editor"></div>
                        <input type="hidden" id="admin_message" name="admin_message" value="">

                        <div class="col-12 mt-3">
                          <button type="submit" id="getJSON" class="btn btn-primary me-sm-3 me-1 waves-effect waves-light">Submit</button>
                          <button type="reset" class="btn btn-label-secondary waves-effect">Cancel</button>
                        </div>
                    </form>
                    
                </div>
            </div>
        </div>
@endsection

@section('javascripts')
<script src="{{ asset('assets/js/forms-file-upload.js')}}"></script>
<script src="{{ asset('assets/vendor/formBuilder/assets/js/vendor.js')}}"></script>
<script src="{{ asset('assets/vendor/formBuilder/assets/js/form-builder.min.js')}}"></script>
<script src="{{ asset('assets/vendor/formBuilder/assets/js/form-render.min.js')}}"></script>
{{-- <script src="formBuilder/assets/js/demo.min.js"></script> --}}
{{-- <script src="{{ asset('assets/vendor/formBuilder/assets/js/jquery.rateyo.min.js')}}"></script> --}}
<script>
  jQuery(function($) {
  var fbTemplate = document.getElementById('fb-editor');
  
  var options = {
    disableFields: [
      'autocomplete',
      'file',
      'date',
      'header',
      'number',
      'select',
      'hidden',
      'textarea',
      'button',
      'text'
    ],
    showActionButtons: false,
    onAddOption: (optionTemplate, optionIndex) => {
      optionTemplate.label = `Option ${optionIndex.index + 1}`
      optionTemplate.value = `option-${optionIndex.index + 1}`
      optionTemplate.points = `value-${optionIndex.index + 1}`
      return optionTemplate
    }

  };

  var formBuilder = $(fbTemplate).formBuilder(options);

  fbTemplate.addEventListener('mouseover', function(event) {
      var editor = formBuilder.actions.getData('json');
      var value = editor;
      var input = $('.admin_message');
      input.val(value);
  });
  document.addEventListener('fieldAdded', function(){
    var editor = formBuilder.formData;
    var value = editor;
    var input = $('#admin_message');
    input.val(value);
  });
});

</script>
<script>
  setTimeout(function() {
    $('.toast').hide();
  }, 6000);
</script>

<script>
  /**
 *  Pages Authentication
 */

'use strict';
const formAuthentication = document.querySelector('#formValidation');

document.addEventListener('DOMContentLoaded', function (e) {
  (function () {
    // Form validation for Add new record
    if (formAuthentication) {
      const fv = FormValidation.formValidation(formAuthentication, {
        fields: {
          'checklist_id': {
            validators: {
              notEmpty: {
                message: 'Please Select Checklist'
              }
            }
          }
        },
        plugins: {
          trigger: new FormValidation.plugins.Trigger(),
          bootstrap5: new FormValidation.plugins.Bootstrap5({
            eleValidClass: '',
            rowSelector: '.mb-3'
          }),
          submitButton: new FormValidation.plugins.SubmitButton(),

          defaultSubmit: new FormValidation.plugins.DefaultSubmit(),
          autoFocus: new FormValidation.plugins.AutoFocus()
        },
        init: instance => {
          instance.on('plugins.message.placed', function (e) {
            // if (e.element.parentElement.classList.contains('input-group')) {
              e.element.parentElement.insertAdjacentElement('afterend', e.messageElement);
            // }
          });
        }
      });
    }
  })();
});

</script>
@endsection


