@extends('main')

@section('content')
        <div class="container flex-grow-1 container-p-y">
            <div class="card mb-4">
                <h5 class="card-header">Create Category</h5>
                @if(session()->has('error'))
                <div class="bg-danger bs-toast toast toast-placement-ex m-2 fade top-0 start-50 translate-middle-x show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-animation="true" data-bs-autohide="true" data-bs-delay="2000">
                  <div class="toast-header" style="background-color: #f7f7f7 !important;">
                    <i class="ti ti-bell ti-xs me-2 text-danger"></i>
                    <div class="me-auto fw-medium">Error!</div>
                    <button type="button" class="btn-close text-white " data-bs-dismiss="toast" aria-label="Close"></button>
                  </div>
                  <div class="toast-body text-white">
                    {!! session('error') !!}
                  </div>
                </div>
                @endif
                @if(session()->has('success'))
                  <div class="bg-success bs-toast toast toast-placement-ex m-2 fade top-0 start-50 translate-middle-x show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-animation="true" data-bs-autohide="true" data-bs-delay="2000">
                    <div class="toast-header" style="background-color: #f7f7f7 !important;">
                      <i class="ti ti-bell ti-xs me-2 text-success"></i>
                      <div class="me-auto fw-medium">Success!</div>
                      {{-- <small class="text-muted">11 mins ago</small> --}}
                      <button type="button" class="btn-close text-white " data-bs-dismiss="toast" aria-label="Close"></button>
                    </div>
                    <div class="toast-body text-white">
                      {!! session('success') !!}
                    </div>
                  </div>
                @endif
                <div class="card-body">
                    <form action="{{ route('update_admins') }}" method="POST">
                        @csrf
                        <input type="hidden" name="id" id="id" value="{{$id}}">
                        <div class="row">
                            <div class="col-6 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select id="selectpickerBasic" class="selectpicker w-100 h-100" data-style="btn-default" id="status" name="status">
                                    <option value="">Select Status</option>
                                    <option value="2" selected>Active</option>
                                    <option value="1">Inactive</option>
                                </select>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control"  placeholder="" aria-describedby="floatingInputHelp" id="first_name" name="first_name" value="{{ $admins_view[0]['first_name'] }}"/>
                                    <label for="floatingInput">First Name</label>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control" placeholder="" aria-describedby="floatingInputHelp" id="last_name" name="last_name" value="{{ $admins_view[0]['last_name'] }}"/>
                                    <label for="floatingInput">Last Name</label>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" readonly class="form-control"  placeholder="" aria-describedby="floatingInputHelp" id="email" name="email" value="{{ $admins_view[0]['email'] }}"/>
                                    <label for="floatingInput">Email ID</label>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control" placeholder="" aria-describedby="floatingInputHelp" id="job_title" name="job_title" value="{{ $admins_view[0]['job_title'] }}"/>
                                    <label for="floatingInput">Job Title</label>
                                </div>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary me-sm-3 me-1 waves-effect waves-light">Submit</button>
                                <a href="{{ url()->previous() }}" class="btn btn-label-secondary waves-effect">Cancel</a>
                            </div>
                        </div>
                    </form>
                    
                </div>
            </div>
        </div>
@endsection

@section('javascripts')
<script src="{{ asset('assets/js/forms-file-upload.js')}}"></script>
<script>
  setTimeout(function() {
    $('.toast').hide();
  }, 6000);
</script>
@endsection