<!DOCTYPE html>
<html lang="en" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office">
   <head>
      <meta charset="utf-8">
      <meta name="x-apple-disable-message-reformatting">
      <meta http-equiv="x-ua-compatible" content="ie=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <meta name="format-detection" content="telephone=no, date=no, address=no, email=no">
      <!--[if mso]>
      <xml>
         <o:officedocumentsettings>
            <o:pixelsperinch>96</o:pixelsperinch>
         </o:officedocumentsettings>
      </xml>
      <![endif]-->
      <title>{{ $maildata['title'] }}</title>
      <link href="https://fonts.googleapis.com/css?family=Montserrat:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,200;1,300;1,400;1,500;1,600;1,700" rel="stylesheet" media="screen">
      <style>
         .hover-underline:hover {
         text-decoration: underline !important;
         }
         @media (max-width: 600px) {
         .sm-w-full {
         width: 100% !important;
         }
         .sm-px-24 {
         padding-left: 24px !important;
         padding-right: 24px !important;
         }
         .sm-py-32 {
         padding-top: 32px !important;
         padding-bottom: 32px !important;
         }
         .sm-leading-32 {
         line-height: 32px !important;
         }
         }
      </style>
   </head>
   <body style="margin: 0; width: 100%; padding: 0; word-break: break-word; -webkit-font-smoothing: antialiased; background-color: #eceff1;">
      <div role="article" aria-roledescription="email" aria-label="#" lang="en" style="font-family: 'Montserrat', sans-serif; mso-line-height-rule: exactly;">
         <table style="width: 100%; font-family: Montserrat, -apple-system, 'Segoe UI', sans-serif;" cellpadding="0" cellspacing="0" role="presentation">
            <tr>
               <td align="center" style="mso-line-height-rule: exactly; background-color: #eceff1; font-family: Montserrat, -apple-system, 'Segoe UI', sans-serif;">
                  <table class="sm-w-full" style="width: 600px;" cellpadding="0" cellspacing="0" role="presentation">
                     <tr>
                        <td class="sm-py-32 sm-px-24" style="mso-line-height-rule: exactly; padding: 48px; text-align: center; font-family: Montserrat, -apple-system, 'Segoe UI', sans-serif;">
                           <a href="https://leadaudits360.com" style="font-family: 'Montserrat', sans-serif; mso-line-height-rule: exactly;">
                           <img src="https://leadaudits360.com/assets/svg/logo/logo.svg" width="155" alt="Leadaudits360" style="max-width: 100%; vertical-align: middle; line-height: 100%; border: 0;">
                           </a>
                        </td>
                     </tr>
                     <tr>
                        <td align="center" class="sm-px-24" style="font-family: 'Montserrat', sans-serif; mso-line-height-rule: exactly;">
                           <table style="width: 100%;" cellpadding="0" cellspacing="0" role="presentation">
                              <tr>
                                 <td class="sm-px-24" style="mso-line-height-rule: exactly; border-radius: 4px; background-color: #ffffff; padding: 48px; text-align: left; font-family: Montserrat, -apple-system, 'Segoe UI', sans-serif; font-size: 16px; line-height: 24px; color: #626262;">
                                    <p style="font-family: 'Montserrat', sans-serif; mso-line-height-rule: exactly; margin-bottom: 0; font-size: 20px; font-weight: 600;">Hello</p>
                                    <p style="font-family: 'Montserrat', sans-serif; mso-line-height-rule: exactly; margin-top: 0; font-size: 24px; font-weight: 700; color: #155263;">{{ $maildata['username'] }}!</p>
                                    
                                    <p style="font-family: 'Montserrat', sans-serif; mso-line-height-rule: exactly; margin: 0; margin-top: 24px; margin-bottom: 24px;">
                                       <!-- Your 30-day basic plan expires on June 6th, 2024. If you would like an extension to continue exploring our platform's valuable features, please let me know. -->
                                       Your 7-day trail plan expires on June 6th, 2024. If you would like an extension to continue exploring our platform's valuable features, please let me know.
                                    </p>
                                    <p style="font-family: 'Montserrat', sans-serif; mso-line-height-rule: exactly; margin: 0; margin-top: 0px; margin-bottom: 24px;">
                                       Upgrade your plan using the link below.
                                    </p>
                                    
                                    <table cellpadding="0" cellspacing="0" role="presentation">
                                       <tr>
                                          <td style="mso-line-height-rule: exactly; mso-padding-alt: 16px 24px; border-radius: 4px; background-color: #155263; font-family: Montserrat, -apple-system, 'Segoe UI', sans-serif;">
                                             <a href="{{ $data['url'] }}" style="font-family: 'Montserrat', sans-serif; mso-line-height-rule: exactly; display: block; padding-left: 24px; padding-right: 24px; padding-top: 16px; padding-bottom: 16px; font-size: 16px; font-weight: 600; line-height: 100%; color: #ffffff; text-decoration: none;">Click here &rarr;</a>
                                          </td>
                                       </tr>
                                    </table>
                                    <br>
                                    <hr style="border: .8px solid #eceff1;">
                                    <p style="font-family: 'Montserrat', sans-serif; mso-line-height-rule: exactly; margin: 0; margin-bottom: 16px;">Thanks, <br>The Leadsaudits360 Team</p>
                                 </td>
                              </tr>
                              <tr>
                                 <td style="font-family: 'Montserrat', sans-serif; mso-line-height-rule: exactly; height: 20px;"></td>
                              </tr>
                              <tr>
                                 <td style="mso-line-height-rule: exactly; padding-left: 48px; padding-right: 48px; font-family: Montserrat, -apple-system, 'Segoe UI', sans-serif; font-size: 14px; color: #eceff1;">
                                   <p style="font-family: 'Montserrat', sans-serif; mso-line-height-rule: exactly; color: #263238;">
                                     Use of our service and website is subject to our
                                     <a href="https://leadaudits360.com/terms-and-conditions" class="hover-underline" style="font-family: 'Montserrat', sans-serif; mso-line-height-rule: exactly; color: #155263; text-decoration: none;">Terms of Use</a> and
                                     <a href="https://leadaudits360.com/privacy-policy" class="hover-underline" style="font-family: 'Montserrat', sans-serif; mso-line-height-rule: exactly; color: #155263; text-decoration: none;">Privacy Policy</a>.
                                   </p>
                                 </td>
                               </tr>
                           </table>
                        </td>
                     </tr>
                  </table>
               </td>
            </tr>
         </table>
      </div>
   </body>
</html>