

<?php $__env->startSection('content'); ?>
<?php if(isset($plans['data']) && !empty($plans['data']['plan'])): ?>
<section class="section-py bg-body first-section-pt">
    <div class="container mt-2">
      <div class="card px-3">
        <div class="row">
            
          <div class="col-lg-7 card-body border-end">
            <h4 class="mb-2">Checkout</h4>
            <p class="mb-0">
                Choose the subscription plan that best suits your needs and complete your purchase.
            </p>
            
            
            <div id="form-credit-card">
              <h4 class="mt-4 pt-2">Credit Card Info</h4>
              <form id="payment-form">
                <div class="row g-3">
                    <div class="col-md-12">
                        <label class="form-label" for="billings-card-name">Name</label>
                        <input type="text" id="customer-name" class="form-control" name="customerName" placeholder="Name" />
                        <div class="error-message" id="customer-name-error"></div>
                    </div>             
                    <div class="col-12">
                        <label class="form-label" for="card-element">Card Details</label>
                        <div id="card-element" class="form-control"></div>
                        <div class="error-message" id="card-element-error"></div>
                    </div>
                </div>
            </form>
            </div>
          </div>
          <div class="col-lg-5 card-body">
            <h4 class="mb-2">Order Summary</h4>
            <p class="pb-2 mb-0">
                Review your order details and ensure everything is correct before completing your subscription.
            </p>
            <div class="bg-lighter p-4 rounded mt-4">
              
              <div class="d-flex align-items-center">
                <h1 class="text-heading display-5 mb-1">$<?php echo e($plans['data']['plan'][0]['amount']); ?></h1>
                <sub>/month</sub>
              </div>
              <div class="d-grid">
                
              </div>
            </div>
            <div>
              <div class="d-flex justify-content-between align-items-center mt-3">
                <p class="mb-0">Subtotal</p>
                <h6 class="mb-0">$<?php echo e($plans['data']['plan'][0]['amount']); ?></h6>
              </div>
              
              <hr />
              <div class="d-flex justify-content-between align-items-center mt-3 pb-1">
                <p class="mb-0">Total</p>
                <h6 class="mb-0">$<?php echo e($plans['data']['plan'][0]['amount']); ?></h6>
              </div>
              <div class="d-grid mt-3">
                <button class="btn btn-success" id="proceed-btn">
                  <span class="me-2">Proceed with Payment</span>
                  <i class="ti ti-arrow-right scaleX-n1-rtl"></i>
                </button>
              </div>

              <p class="mt-4 pt-2">
                By continuing, you accept to our Terms of Services and Privacy Policy. Please note that payments are
                non-refundable.
              </p>
            </div>
          </div>

        </div>
      </div>
    </div>
</section>


<div id="card-errors" role="alert"></div>
<div id="payment-result" role="alert"></div>

<?php else: ?>
<section class="section-py first-section-pt help-center-header position-relative overflow-hidden mt-4">
      <h3 class="text-center">No Plans Available</h3>
      <p class="text-center px-3 mb-0">Please select proper plan.</p>
</section>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    var stripe = Stripe('<?php echo e(env("STRIPE_KEY")); ?>');
    var elements = stripe.elements();
    
    var style = {
        base: {
            color: '#32325d',
            fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
            fontSmoothing: 'antialiased',
            fontSize: '16px',
            '::placeholder': {
                color: '#aab7c4'
            }
        },
        invalid: {
            color: '#fa755a',
            iconColor: '#fa755a'
        }
    };
    
    var cardElement = elements.create('card', { 
        style: style,
        hidePostalCode: true // Hide the postal code field
    });
    cardElement.mount('#card-element');

    var form = document.querySelector('#payment-form');

    document.getElementById('proceed-btn').addEventListener('click', async function (event) {
    event.preventDefault();
    
    // Disable the button to prevent multiple submissions
    this.disabled = true;

    // Display processing message
    this.innerHTML = '<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>Processing...';

    // Reset error messages
    document.querySelectorAll('.error-message').forEach(function (element) {
        element.innerHTML = '';
    });

    // Validate customer name
    const nameInput = document.getElementById('customer-name');
    if (!nameInput.value.trim()) {
        document.getElementById('customer-name-error').innerText = 'Please enter name.';
        this.disabled = false; // Re-enable the button
        this.innerHTML = '<span class="me-2">Proceed with Payment</span><i class="ti ti-arrow-right scaleX-n1-rtl"></i>'; // Reset button text
        return;
    }

    const { paymentMethod, error } = await stripe.createPaymentMethod('card', cardElement);
    
    if (error) {
        // Handle errors
        console.error(error);
        // Re-enable the button
        this.disabled = false;
        // Reset button text
        this.innerHTML = '<span class="me-2">Proceed with Payment</span><i class="ti ti-arrow-right scaleX-n1-rtl"></i>';
        
        // Display error messages
        if (error.type === 'validation_error') {
            switch (error.code) {
                case 'incomplete_number':
                    document.getElementById('card-element-error').innerText = 'Your card number is incomplete.';
                    break;
                case 'incomplete_expiry':
                    document.getElementById('card-element-error').innerText = 'Your card\'s expiration date is incomplete.';
                    break;
                case 'incomplete_cvc':
                    document.getElementById('card-element-error').innerText = 'Your card\'s security code is incomplete.';
                    break;
                case 'invalid_expiry_year_past':
                    document.getElementById('card-element-error').innerText = 'Your card\'s expiration year is in the past.';
                    break;
                // Add more error checks as needed
                default:
                    // Handle other validation errors
                    break;
            }
        }



        return;
    }

    // Proceed with form submission
    var submitEvent = new Event('submit', {
        bubbles: true,
        cancelable: true,
    });
    form.dispatchEvent(submitEvent);
});



    form.addEventListener('submit', async function (event) {
        event.preventDefault();
        
        const { paymentMethod, error } = await stripe.createPaymentMethod('card', cardElement);
        
        if (error) {
            // Handle errors
            console.error(error);
            return;
        }

        const url = window.location.href;
        const lastId = url.substring(url.lastIndexOf('/') + 1);

        const response = await fetch('<?php echo e(route("stripe.post")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({
                stripePaymentMethodId: paymentMethod.id,
                customerName: document.getElementById('customer-name').value,
                id: lastId
            })
        });

        const result = await response.json();
        
        if (result.error) {
            // Handle errors
            // console.error(result.error);
            var proceedButton = document.getElementById('proceed-btn');
            // Re-enable the button
            proceedButton.disabled = false;
            // Reset button text
            proceedButton.innerHTML = '<span class="me-2">Proceed with Payment</span><i class="ti ti-arrow-right scaleX-n1-rtl"></i>';
            
            
            Swal.fire({
                    icon: "error",
                    title: "Oops...",
                    text: result.error,
            });
     
        } else {
            stripe.confirmCardPayment(result.clientSecret).then(function (result) {
                if (result.error) {
                    // Handle errors
                    console.error(result.error);

                    Swal.fire({
                    icon: "error",
                    title: "Oops...",
                    text: result.error,
                    // footer: '<a href="#">Why do I have this issue?</a>'
                    });



                } else {
                    if (result.paymentIntent.status === 'succeeded') {
                        // Payment successful
                        console.log('Payment successful!');
                        var proceedButton = document.getElementById('proceed-btn');
                        // Re-enable the button
                        proceedButton.disabled = false;
                        // Reset button text
                        proceedButton.innerHTML = '<span class="me-2">Proceed with Payment</span><i class="ti ti-arrow-right scaleX-n1-rtl"></i>';
                        
                        Swal.fire({
                        title: "Payment Successful",
                        // text: "You clicked the button!",
                        icon: "success"
                        });
                        setTimeout(function() {
                                    window.location.href = '/subscription'; // Replace with your redirect URL
                        }, 3000); 

                    } else if (result.paymentIntent.status === 'requires_action') {
                        // Handle payment requires action
                        window.location.href = result.paymentIntent.next_action.redirect_to_url.url;
                    }
                }
            }).catch(function (error) {
                console.error('Error:', error);

                Swal.fire({
                    icon: "error",
                    title: "Oops...",
                    text: "An error occurred. Please try again later.",
                });
            });
        }
    });
});

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\umesh_laravelcode\lensaudits\resources\views/pages/plan/payment.blade.php ENDPATH**/ ?>