
<?php $__env->startSection('content'); ?>
        <div class="container flex-grow-1 container-p-y">
            <div class="card mb-4">
                <h5 class="card-header">Update Location</h5>
                <div class="card-body">
                    <form id="locationFormUpdate" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-6 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select id="company_id" name="company_id" class="selectpicker w-100" data-style="btn-default">
                                    
                                    <option value="">Select Company</option>
                                    <?php if(!empty($companies['data']['department_list'])): ?>
                                    <?php $__currentLoopData = $companies['data']['department_list']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($company['id']); ?>" <?php echo e($location['data']['locations'][0]['company_id'] == $company['id'] ? 'selected' : ''); ?>><?php echo e($company['company_name']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                                <span id="company_idError" class="error"></span>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="name" name="name" placeholder="" aria-describedby="floatingInputHelp" value="<?php echo e($location['data']['locations'][0]['name']); ?>" />
                                    <label for="floatingInput">Location Name</label>
                                    <span id="nameError" class="error"></span>
                                </div>
                            </div>
                            
                            <div class="col-6 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select id="time_zone" name="time_zone" class="selectpicker w-100 h-100" data-style="btn-default">
                                    <option value="">Select Timezone</option>
                                    <option value="GMT +5:30" <?php echo e(isset($location['data']['locations'][0]['time_zone']) && $location['data']['locations'][0]['time_zone'] == 'GMT +5:30' ? 'selected' : ''); ?>>GMT +5:30</option>
                                    <option value="GMT +4" <?php echo e(isset($location['data']['locations'][0]['time_zone']) && $location['data']['locations'][0]['time_zone'] == 'GMT +4' ? 'selected' : ''); ?>>GMT +4</option>
                                    <!-- Add more options as needed -->
                                </select>                                
                                <span id="time_zoneError" class="error"></span>
                            </div>
                            
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="postcode" name="postcode" placeholder="" aria-describedby="floatingInputHelp" value="<?php echo e($location['data']['locations'][0]['postcode']); ?>" />
                                    <label for="floatingInput">Postcode/Zipcode</label>
                                    <span id="postcodeError" class="error"></span>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="textarea" class="form-control" id="address" name="address" placeholder="" aria-describedby="floatingInputHelp" value="<?php echo e($location['data']['locations'][0]['address']); ?>"  />
                                    <label for="floatingInput">Address</label>
                                    <span id="addressError" class="error"></span>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select id="selectpickerBasic" class="selectpicker w-100 h-100" data-style="btn-default" id="status" name="status">
                                    
                                    <option value="1" selected>Active</option>
                                    <option value="2">Inactive</option>
                                </select>
                            </div>
                            <input type="hidden" class="form-control" placeholder="" aria-describedby="floatingInputHelp" id="id" name="id" value="<?php echo e($location['data']['locations'][0]['id']); ?>"  />
                            
                            <div class="col-12">
                                <button id="location_update_submit" type="button" class="btn btn-primary me-sm-3 me-1 waves-effect waves-light">Submit</button>
                                <button type="reset" class="btn btn-label-secondary waves-effect">Cancel</button>
                            </div>
                        </div>
                    </form>
                    
                </div>
            </div>
        </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascripts'); ?>
<!-- <script src="<?php echo e(asset('assets/datatable/users-datatables.js')); ?>"></script> -->
<script src="<?php echo e(asset('assets/js/forms-file-upload.js')); ?>"></script>
<script>
    document.addEventListener('DOMContentLoaded', function (e) {
        

const formaddRecord = document.getElementById('locationFormUpdate');

if (!formaddRecord) {
    console.error('Form not found!');
    return;
}

// Form validation for Add new record
fv = FormValidation.formValidation(formaddRecord, {
    fields: {
        company_id: {
            validators: {
                notEmpty: {
                    message: 'Company is required'
                }
            }
        },
        name: {
            validators: {
                notEmpty: {
                    message: 'Location name is required'
                }
            }
        },
        time_zone: {
            validators: {
                notEmpty: {
                    message: 'Time zone is required'
                }
            }
        },
        postcode: {
            validators: {
                notEmpty: {
                    message: 'Postcode/Zipcode is required'
                }
            }
        },
        address: {
            validators: {
                notEmpty: {
                    message: 'Address is required'
                }
            }
        },
    
    },
    plugins: {
        trigger: new FormValidation.plugins.Trigger(),
        bootstrap5: new FormValidation.plugins.Bootstrap5({
            rowSelector: '.col-6, .col-12'
        }),
        submitButton: new FormValidation.plugins.SubmitButton(),
        autoFocus: new FormValidation.plugins.AutoFocus()
    },
    init: instance => {
        instance.on('plugins.message.placed', function (e) {
            if (e.element.parentElement.classList.contains('form-floating')) {
                e.element.parentElement.insertAdjacentElement('afterend', e.messageElement);
            }
        });
    }
});


$('#location_update_submit').click(function() {
                fv.validate().then(function(status) {
                    if (status === 'Valid') {
                        var updateLocationRoute = '<?php echo e(route('update_location')); ?>';
                        var form = document.getElementById("locationFormUpdate");

                        fetch(updateLocationRoute, {
                            method: 'POST',
                            body: new FormData(form),
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.status==true) {
                                Swal.fire({
                                    title: "Updated",
                                    text: data.message,
                                    icon: "success",
                                    confirmButtonText: "OK",
                                });
                                setTimeout(function() {
                                    window.location.href = '/locations';
                                }, 2000); 
                            } else {
                                alert('An error occurred. Please try again.');
                            }
                        })
                        .catch(error => {
                            alert('Failed to Update location. Please try again.');
                            console.error('Error:', error);
                        });
                    }
                });
            });
    
});
    
    </script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/leadaudits360/resources/views/pages/locations/update.blade.php ENDPATH**/ ?>