
<?php $__env->startSection('content'); ?>

    <!-- Pricing Plans -->
    <section class="section-py first-section-pt mt-4">
        <div class="container">
          <h2 class="text-center mb-2">Subscription Plans</h2>
          <p class="text-center">
            Choose the plan that suits your needs and experience the effectiveness and ease-of-use of our software.
          </p>
  
          <div class="row mx-0 gy-3 px-lg-5 mt-4">

            <?php if(!empty($plans['data']['plan'])): ?>
            <?php $__currentLoopData = $plans['data']['plan']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <div class="col-lg mb-md-0 mb-4">
                <div class="card border rounded shadow-none">
                  <div class="card-body">
                    <h3 class="card-title text-center text-capitalize mb-1"><?php echo e($plan['title']); ?></h3>
                    <p class="text-center"><?php echo e($plan['subtitle']); ?></p>
                    <div class="text-center">
                      <div class="d-flex justify-content-center">
                        <sup class="h6 pricing-currency mt-3 mb-0 me-1 text-primary">$</sup>
                        <h1 class="display-4 mb-0 text-primary"><?php echo e($plan['amount']); ?></h1>
                        <sub class="h6 pricing-duration mt-auto mb-2 text-muted fw-normal">/month</sub>
                      </div>
                    </div>
    
                    
                     <?php
                     $encryptedId = Crypt::encrypt($plan['id']);
                     ?>
                        
                        
                        
                        <?php if($users['data']['profile']['plan_actived'] == $plan['id']): ?>
                        <?php if(1 == $plan['id']): ?>
                        <a href="#" class="btn btn-label-success d-grid w-100">Your Current Plan</a>
                        <?php else: ?>
                          <?php if($users['data']['profile']['days'] <= 7): ?>
                          <a href="<?php echo e(route('payment', ['id' => $encryptedId])); ?>" class="btn btn-label-success d-grid w-100">Your Current Plan</a>
                          <?php else: ?> 
                          <a href="#" class="btn btn-label-success d-grid w-100">Your Current Plan</a>
                          <?php endif; ?>
                        <?php endif; ?>
                        <?php elseif($plan['id'] == 1): ?>
                            <a href="#" class="btn btn-primary d-grid w-100 disabled">Trial Plan</a>
                        <?php elseif($users['data']['profile']['id'] != null): ?>
                            <a href="<?php echo e(route('payment', ['id' => $encryptedId])); ?>" class="btn btn-primary d-grid w-100">Subscribe Now</a>
                        <?php endif; ?>
                  </div>
                </div>
            </div>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>          
  
          </div>
        </div>
      </section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascripts'); ?>
<script>
  <?php if(session('success')): ?>
      Swal.fire({
          icon: "success",
          title: "<?php echo e(session('success')); ?>",
          // text: "An error occurred. Please try again later.",
      });
  <?php endif; ?>

  <?php if(session('error')): ?>
      Swal.fire({
          title: 'Oops...',
          text: '<?php echo e(session('error')); ?>',
          icon: 'error',
          confirmButtonText: 'OK'
      });
  <?php endif; ?>
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/leadaudits360/resources/views/pages/plan/subscription.blade.php ENDPATH**/ ?>