

<?php $__env->startSection('content'); ?>
        <div class="container flex-grow-1 container-p-y">
            <div class="card mb-4">
                <h5 class="card-header">Create Checklist</h5>
                <?php if(session()->has('error')): ?>
                <div class="bg-danger bs-toast toast toast-placement-ex m-2 fade top-0 start-50 translate-middle-x show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-animation="true" data-bs-autohide="true" data-bs-delay="2000">
                  <div class="toast-header" style="background-color: #f7f7f7 !important;">
                    <i class="ti ti-bell ti-xs me-2 text-danger"></i>
                    <div class="me-auto fw-medium">Error!</div>
                    <button type="button" class="btn-close text-white " data-bs-dismiss="toast" aria-label="Close"></button>
                  </div>
                  <div class="toast-body text-white">
                    <?php echo session('error'); ?>

                  </div>
                </div>
                <?php endif; ?>
                <?php if(session()->has('success')): ?>
                  <div class="bg-success bs-toast toast toast-placement-ex m-2 fade top-0 start-50 translate-middle-x show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-animation="true" data-bs-autohide="true" data-bs-delay="2000">
                    <div class="toast-header" style="background-color: #f7f7f7 !important;">
                      <i class="ti ti-bell ti-xs me-2 text-success"></i>
                      <div class="me-auto fw-medium">Success!</div>
                      
                      <button type="button" class="btn-close text-white " data-bs-dismiss="toast" aria-label="Close"></button>
                    </div>
                    <div class="toast-body text-white">
                      <?php echo session('success'); ?>

                    </div>
                  </div>
                <?php endif; ?>
                <div class="card-body">
                    <form action="<?php echo e(route('store_checklist')); ?>" method="POST" id="formValidation">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-12 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select id="selectpickerBasic" class="selectpicker w-100" data-style="btn-default" id="category_id" name="category_id">
                                    <option value="">Select Category</option>
                                    <?php $__currentLoopData = $category['data']['category']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user['id']); ?>"><?php echo e($user['name']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <span class="errors"></span>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="name" name="name" placeholder="" aria-describedby="floatingInputHelp" />
                                    <label for="floatingInput">Name</label>
                                </div>
                                <span class="errors"></span>
                            </div>
                            <div class="col-6 mb-3">
                                <!-- <label for="selectpickerBasic" class="form-label">Basic</label> -->
                                <select id="selectpickerBasic" class="selectpicker w-100" data-style="btn-default" id="status" name="status">
                                    <option value="">Select Status</option>
                                    <option value="1">Active</option>
                                    <option value="2">Inactive</option>
                                </select>
                                <span class="errors"></span>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary me-sm-3 me-1 waves-effect waves-light">Submit</button>
                                <button type="reset" class="btn btn-label-secondary waves-effect">Cancel</button>
                            </div>
                        </div>
                    </form>
                    
                </div>
            </div>
        </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascripts'); ?>
<script src="<?php echo e(asset('assets/js/forms-file-upload.js')); ?>"></script>
<script>
  setTimeout(function() {
    $('.toast').hide();
  }, 6000);
</script>
<script>
'use strict';
const formAuthentication = document.querySelector('#formValidation');

document.addEventListener('DOMContentLoaded', function (e) {
  (function () {
    // Form validation for Add new record
    if (formAuthentication) {
      const fv = FormValidation.formValidation(formAuthentication, {
        fields: {
          'category_id': {
            validators: {
              notEmpty: {
                message: 'Please select category.'
              }
            }
          },
          'name': {
            validators: {
              notEmpty: {
                message: 'Please enter name.'
              }
            }
          },
          'status': {
            validators: {
              notEmpty: {
                message: 'Please select status.'
              }
            }
          }
        },
        plugins: {
          trigger: new FormValidation.plugins.Trigger(),
          bootstrap5: new FormValidation.plugins.Bootstrap5({
            eleValidClass: '',
            rowSelector: '.mb-3'
          }),
          submitButton: new FormValidation.plugins.SubmitButton(),

          defaultSubmit: new FormValidation.plugins.DefaultSubmit(),
          autoFocus: new FormValidation.plugins.AutoFocus()
        },
        init: instance => {
          instance.on('plugins.message.placed', function (e) {
            // if (e.element.parentElement.classList.contains('input-group')) {
              e.element.parentElement.insertAdjacentElement('afterend', e.messageElement);
            // }
          });
        }
      });
    }
  })();
});

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/leadaudits360/resources/views/pages/checklist/create.blade.php ENDPATH**/ ?>