<!DOCTYPE html>
<html>
<head>
    <title>Stripe Payment</title>
    <script src="https://js.stripe.com/v3/"></script>
</head>
<body>
    <div class="container">
        <h1>Stripe Payment</h1>

        <form id="payment-form">
            <div>
                <label for="customer-name">Name</label>
                <input id="customer-name" name="customerName" type="text" required>
            </div>
            <div>
                <label for="card-element">Credit or debit card</label>
                <div id="card-element"></div>
            </div>

            <button id="submit">Submit Payment</button>
        </form>

        <div id="card-errors" role="alert"></div>
        <div id="payment-result" role="alert"></div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var stripe = Stripe('<?php echo e(env("STRIPE_KEY")); ?>');
            var elements = stripe.elements();
            var cardElement = elements.create('card');
            cardElement.mount('#card-element');

            var form = document.getElementById('payment-form');
            form.addEventListener('submit', async function (event) {
                event.preventDefault();
                
                const { paymentMethod, error } = await stripe.createPaymentMethod('card', cardElement);
                
                if (error) {
                    document.getElementById('card-errors').textContent = error.message;
                    return;
                }

                const response = await fetch('<?php echo e(route("stripe.post")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    },
                    body: JSON.stringify({
                        stripePaymentMethodId: paymentMethod.id,
                        customerName: document.getElementById('customer-name').value,
                        // addressLine1: document.getElementById('address-line1').value,
                        // addressLine2: document.getElementById('address-line2').value,
                        // city: document.getElementById('city').value,
                        // state: document.getElementById('state').value,
                        // postalCode: document.getElementById('postal-code').value,
                        // country: document.getElementById('country').value
                    })
                });

                const result = await response.json();
                
                if (result.error) {
                    document.getElementById('card-errors').textContent = result.error.message;
                } else {
                    stripe.confirmCardPayment(result.clientSecret).then(function (result) {
                        if (result.error) {
                            document.getElementById('card-errors').textContent = result.error.message;
                        } else {
                            if (result.paymentIntent.status === 'succeeded') {
                                document.getElementById('payment-result').textContent = 'Payment successful!';
                            } else if (result.paymentIntent.status === 'requires_action') {
                                window.location.href = result.paymentIntent.next_action.redirect_to_url.url;
                            }
                        }
                    });
                }
            });
        });
    </script>
</body>
</html>
<?php /**PATH C:\umesh_laravelcode\lensaudits\resources\views/stripe.blade.php ENDPATH**/ ?>