

<?php $__env->startSection('content'); ?>
        <div class="container-xxl flex-grow-1 container-p-y">
            
            <div class="row">
                <!-- User Sidebar -->
                <div class="col-xl-4 col-lg-5 col-md-5 order-1 order-md-0">
                  <!-- User Card -->
                  <div class="card mb-4">
                    <div class="card-body">
                      <div class="user-avatar-section">
                        <div class="d-flex align-items-center flex-column">
                          
                          <div class="avatar avatar-xl me-2 mb-3">
                            <span class="avatar-initial rounded bg-label-info">
                                <?php
                                    $str = $users['data']['company_list'][0]['company_name'];
                                    $words = explode(' ', $str);
                                    $result = $words[0][0]. $words[1][0];
                                    echo $result;
                                  ?>
                            </span>
                          </div>
                          <div class="user-info text-center">
                            <h4 class="mb-2"><?php echo e($users['data']['company_list'][0]['company_name']); ?></h4>
                            <span class="badge bg-label-secondary">#<?php echo e($users['data']['company_list'][0]['user_id']); ?></span>
                          </div>
                        </div>
                      </div>
                      <div class="d-flex align-items-center border mt-3 rounded p-2">
                        <div class="badge rounded bg-label-primary me-4 p-2"><i class="ti ti-checklist ti-lg"></i></div>
                            <div class="card-info">
                                <h5 class="mb-0"><?php echo e($users['data']['company_list'][0]['user_plan']); ?></h5>
                                <small>Plan Active</small>
                            </div>
                      </div>
                      <p class="mt-4 small text-uppercase text-muted">Details</p>
                      <div class="info-container">
                        <ul class="list-unstyled">
                          <li class="mb-2 pt-1">
                            <span class="fw-medium me-1">Email ID :</span>
                            <span><?php echo e($users['data']['company_list'][0]['user_email']); ?></span>
                          </li>
                          <li class="mb-2 pt-1">
                            <span class="fw-medium me-1">Mobile No :</span>
                            <span>+<?php echo e($users['data']['company_list'][0]['country_code']); ?> <?php echo e($users['data']['company_list'][0]['user_mobile']); ?></span>
                          </li>
                          <li class="mb-2 pt-1">
                            <span class="fw-medium me-1">Role :</span>
                            <span><?php echo e($users['data']['company_list'][0]['user_role']); ?></span>
                          </li>
                          <li class="mb-2 pt-1">
                            <span class="fw-medium me-1">Web Access :</span>
                            <span class="badge bg-label-primary">Yes</span>
                          </li>
                          <li class="mb-2 pt-1">
                            <span class="fw-medium me-1">Days :</span>
                            <span><?php echo e($users['data']['company_list'][0]['user_days']); ?></span>
                          </li>
                          <li class="pt-1">
                            <span class="fw-medium me-1">Status :</span>
                            <?php if($users['data']['company_list'][0]['status'] == 'Active'): ?>
                            <span class="badge bg-label-success"><?php echo e($users['data']['company_list'][0]['status']); ?></span>
                            <?php else: ?>
                            <span class="badge bg-label-warning"><?php echo e($users['data']['company_list'][0]['status']); ?></span>
                            <?php endif; ?>
                          </li>
                        </ul>
                      </div>
                    </div>
                  </div>
                  <!-- /User Card -->
                 
                </div>
                <!--/ User Sidebar -->

                <!-- User Content -->
                <div class="col-xl-8 col-lg-7 col-md-7 order-0 order-md-1">
                    <div class="nav-align-top mb-6">
                        <ul class="nav nav-pills mb-4 nav-fill" role="tablist">
                          <li class="nav-item mb-1 mb-sm-0">
                            <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#navs-pills-justified-home" aria-controls="navs-pills-justified-home" aria-selected="true"><span class="d-none d-sm-block"><i class="tf-icons ti ti-building ti-sm me-1_5 align-text-bottom"></i> Department List </span><i class="ti ti-building ti-sm d-sm-none"></i></button>
                          </li>
                          <li class="nav-item mb-1 mb-sm-0">
                            <button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#navs-pills-justified-profile" aria-controls="navs-pills-justified-profile" aria-selected="false"><span class="d-none d-sm-block"><i class="tf-icons ti ti-users-group ti-sm me-1_5 align-text-bottom"></i> Auditor List</span><i class="ti ti-users-group ti-sm d-sm-none"></i></button>
                          </li>
                        </ul>
                        <div class="tab-content p-0">
                          <div class="tab-pane fade show active" id="navs-pills-justified-home" role="tabpanel">
                            <div class="card-datatable table-responsive pt-0">
                                <table class="datatables-basic table datatables-department">
                                  <thead>
                                    <tr>
                                      <th></th>
                                      <th></th>
                                      <th>ID</th>
                                      <th>Name</th>
                                      <th>Last Modified</th>
                                      <th>Status</th>
                                    </tr>
                                  </thead>
                                </table>
                            </div>
                          </div>
                          <div class="tab-pane fade" id="navs-pills-justified-profile" role="tabpanel">
                            <div class="card-datatable table-responsive pt-0">
                                <table class="datatables-assignees table">
                                  <thead>
                                    <tr>
                                      <th></th>
                                      <th></th>
                                      <th>ID</th>
                                      <th>Name</th>
                                      <th>Email ID</th>
                                      <th>Audit</th>
                                      <th>Last Modified</th>
                                      <th>Status</th>
                                    </tr>
                                  </thead>
                                </table>
                            </div>
                          </div>
                        </div>
                      </div>
                  
                </div>
                <!--/ User Content -->
              </div>

        </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascripts'); ?>
<script>
'use strict';
$(function () {
  var dt_basic_table = $('.datatables-department'),
    dt_basic;

  // DataTable with buttons
  // --------------------------------------------------------------------
  
  if (dt_basic_table.length) {
    dt_basic = dt_basic_table.DataTable({
      ajax: '<?php echo e(route('details_users_department_api',$id)); ?>',
      columns: [
        { data: '' },
        { data: 'id' },
        { data: 'id' },
        { data: 'department_name' },
        { data: 'department_date' },
        { data: 'department_status' }
      ],
      columnDefs: [
        {
          // For Responsive
          className: 'control',
          orderable: false,
          searchable: false,
          responsivePriority: 2,
          targets: 0,
          render: function (data, type, full, meta) {
            return '';
          }
        },
        {
          // For Checkboxes
          targets: 1,
          orderable: false,
          searchable: false,
          responsivePriority: 3,
          checkboxes: true,
          visible : false,
          render: function () {
            return '<input type="checkbox" class="dt-checkboxes form-check-input">';
          },
          checkboxes: {
            selectAllRender: '<input type="checkbox" class="form-check-input">'
          }
        },
        {
          targets: 2,
          searchable: false,
          visible: false
        },
        {
          // Avatar image/badge, Name and post
          targets: 3,
          responsivePriority: 4,
          render: function (data, type, full, meta) {
            var $user_img = full['avatar'],
              $name = full['department_name'],
              $post = full['department_id'];
            if ($user_img) {
              // For Avatar image
              var $output =
                '<img src="' + assetsPath + 'img/avatars/' + $user_img + '" alt="Avatar" class="rounded-circle">';
            } else {
              // For Avatar badge
              var stateNum = Math.floor(Math.random() * 6);
              var states = ['success', 'danger', 'warning', 'info', 'primary', 'secondary'];
              var $state = states[stateNum],
                $name = full['department_name'],
                $initials = $name.match(/\b\w/g) || [];
              $initials = (($initials.shift() || '') + ($initials.pop() || '')).toUpperCase();
              $output = '<span class="avatar-initial rounded-circle bg-label-' + $state + '">' + $initials + '</span>';
            }
            // Creates full output for row
            var $row_output =
              '<div class="d-flex justify-content-start align-items-center user-name">' +
              '<div class="avatar-wrapper">' +
              '<div class="avatar me-2">' +
              $output +
              '</div>' +
              '</div>' +
              '<div class="d-flex flex-column">' +
              '<span class="emp_name text-truncate">' +
              $name +
              '</span>' +
              '<small class="emp_post text-truncate text-muted">#' +
              $post +
              '</small>' +
              '</div>' +
              '</div>';
            return $row_output;
          }
        },
        {
          // Due Date
          targets: 4,
          render: function (data, type, full, meta) {
            var $updated_at = new Date(full['department_date']);
            // Creates full output for row
            if(full['department_date'] != null){
                var $row_output =
                '<span class="d-none">' +
                moment($updated_at).format('YYYYMMDD') +
                '</span>' +
                moment($updated_at).format('DD MMM YYYY');
                $updated_at;
                return $row_output;
            }else{
                var $row_output = '';
                return $row_output;
            }
          }
        },
        {
          // Label
          targets: -1,
          render: function (data, type, full, meta) {
            var $status_number = full['department_status'];
            var $status = {
              1: { title: 'Active', class: 'bg-label-success' },
              2: { title: 'Inactive', class: ' bg-label-warning' },
              3: { title: 'Deleted', class: ' bg-label-danger' }
            };
            if (typeof $status[$status_number] === 'undefined') {
              return data;
            }
            return (
              '<span class="badge ' + $status[$status_number].class + '">' + $status[$status_number].title + '</span>'
            );
          }
        }
      ],
      order: [[2, 'desc']],
      dom: '<"card-header flex-column flex-md-row"<"head-label text-center"><"dt-action-buttons text-end pt-3 pt-md-0"B>><"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6 d-flex justify-content-center justify-content-md-end"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
      displayLength: 10,
      lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
      buttons: [],
      responsive: {
        details: {
          display: $.fn.dataTable.Responsive.display.modal({
            header: function (row) {
              var data = row.data();
              return 'Details of ' + data['department_name'];
            }
          }),
          type: 'column',
          renderer: function (api, rowIdx, columns) {
            var data = $.map(columns, function (col, i) {
              return col.title !== '' // ? Do not show row in modal popup if title is blank (for check box)
                ? '<tr data-dt-row="' +
                    col.rowIndex +
                    '" data-dt-column="' +
                    col.columnIndex +
                    '">' +
                    '<td>' +
                    col.title +
                    ':' +
                    '</td> ' +
                    '<td>' +
                    col.data +
                    '</td>' +
                    '</tr>'
                : '';
            }).join('');
            return data ? $('<table class="table"/><tbody />').append(data) : false;
          }
        }
      }
    });
  }
});
</script>

<script>
'use strict';
$(function () {
  var dt_basic_table = $('.datatables-assignees'),
    dt_basic;

  // DataTable with buttons
  // --------------------------------------------------------------------
  
  if (dt_basic_table.length) {
    dt_basic = dt_basic_table.DataTable({
      ajax: '<?php echo e(route('details_users_assignees_api',$id)); ?>',
      columns: [
        { data: '' },
        { data: 'id' },
        { data: 'id' },
        { data: 'auditor_name' },
        { data: 'auditor_email' },
        { data: 'auditor_audits' },
        { data: 'auditor_date' },
        { data: 'auditor_status' }
      ],
      columnDefs: [
        {
          // For Responsive
          className: 'control',
          orderable: false,
          searchable: false,
          responsivePriority: 2,
          targets: 0,
          render: function (data, type, full, meta) {
            return '';
          }
        },
        {
          // For Checkboxes
          targets: 1,
          orderable: false,
          searchable: false,
          responsivePriority: 3,
          checkboxes: true,
          visible : false,
          render: function () {
            return '<input type="checkbox" class="dt-checkboxes form-check-input">';
          },
          checkboxes: {
            selectAllRender: '<input type="checkbox" class="form-check-input">'
          }
        },
        {
          targets: 2,
          searchable: false,
          visible: false
        },
        {
          // Avatar image/badge, Name and post
          targets: 3,
          responsivePriority: 4,
          render: function (data, type, full, meta) {
            var $user_img = full['avatar'],
              $name = full['auditor_name'],
              $post = full['auditor_id'];
            if ($user_img) {
              // For Avatar image
              var $output =
                '<img src="' + assetsPath + 'img/avatars/' + $user_img + '" alt="Avatar" class="rounded-circle">';
            } else {
              // For Avatar badge
              var stateNum = Math.floor(Math.random() * 6);
              var states = ['success', 'danger', 'warning', 'info', 'primary', 'secondary'];
              var $state = states[stateNum],
                $name = full['auditor_name'],
                $initials = $name.match(/\b\w/g) || [];
              $initials = (($initials.shift() || '') + ($initials.pop() || '')).toUpperCase();
              $output = '<span class="avatar-initial rounded-circle bg-label-' + $state + '">' + $initials + '</span>';
            }
            // Creates full output for row
            var $row_output =
              '<div class="d-flex justify-content-start align-items-center user-name">' +
              '<div class="avatar-wrapper">' +
              '<div class="avatar me-2">' +
              $output +
              '</div>' +
              '</div>' +
              '<div class="d-flex flex-column">' +
              '<span class="emp_name text-truncate">' +
              $name +
              '</span>' +
              '<small class="emp_post text-truncate text-muted">#' +
              $post +
              '</small>' +
              '</div>' +
              '</div>';
            return $row_output;
          }
        },
        {
          // Due Date
          targets: 6,
          render: function (data, type, full, meta) {
            var $updated_at = new Date(full['auditor_date']);
            // Creates full output for row
            if(full['auditor_date'] != null){
                var $row_output =
                '<span class="d-none">' +
                moment($updated_at).format('YYYYMMDD') +
                '</span>' +
                moment($updated_at).format('DD MMM YYYY');
                $updated_at;
                return $row_output;
            }else{
                var $row_output = '';
                return $row_output;
            }
          }
        },
        {
          // Label
          targets: -1,
          render: function (data, type, full, meta) {
            var $status_number = full['auditor_status'];
            var $status = {
              1: { title: 'Active', class: 'bg-label-success' },
              2: { title: 'Inactive', class: ' bg-label-warning' },
              3: { title: 'Deleted', class: ' bg-label-danger' }
            };
            if (typeof $status[$status_number] === 'undefined') {
              return data;
            }
            return (
              '<span class="badge ' + $status[$status_number].class + '">' + $status[$status_number].title + '</span>'
            );
          }
        }
      ],
      order: [[2, 'desc']],
      dom: '<"card-header flex-column flex-md-row"<"head-label text-center"><"dt-action-buttons text-end pt-3 pt-md-0"B>><"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6 d-flex justify-content-center justify-content-md-end"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
      displayLength: 10,
      lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
      buttons: [],
      responsive: {
        details: {
          display: $.fn.dataTable.Responsive.display.modal({
            header: function (row) {
              var data = row.data();
              return 'Details of ' + data['auditor_name'];
            }
          }),
          type: 'column',
          renderer: function (api, rowIdx, columns) {
            var data = $.map(columns, function (col, i) {
              return col.title !== '' // ? Do not show row in modal popup if title is blank (for check box)
                ? '<tr data-dt-row="' +
                    col.rowIndex +
                    '" data-dt-column="' +
                    col.columnIndex +
                    '">' +
                    '<td>' +
                    col.title +
                    ':' +
                    '</td> ' +
                    '<td>' +
                    col.data +
                    '</td>' +
                    '</tr>'
                : '';
            }).join('');
            return data ? $('<table class="table"/><tbody />').append(data) : false;
          }
        }
      }
    });
  }
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/leadaudits360/public_html/app_leadaudits360/resources/views/pages/users/userdetails.blade.php ENDPATH**/ ?>