<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('audit_question_reports', function (Blueprint $table) {
            $table->id();
            $table->string('audit_id');
            $table->integer('user_id');
            $table->integer('schedule_id');
            $table->integer('checklist_id');
            $table->string('checklist_name');
            $table->integer('category_id');
            $table->string('category_name');
            $table->integer('section_id');
            $table->string('section_name');

            $table->integer('questions_id');
            $table->string('questions_name');
            $table->string('questions_answer');
            $table->json('questions_answer_array')->nullable();
            $table->json('questions_image')->nullable();
            $table->string('questions_comment')->nullable();
            $table->string('questions_status');

            $table->integer('status');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->timestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('audit_question_reports');
    }
};
