<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->string('invoice_id');
            $table->string('transaction_id');
            $table->integer('bank_id');
            $table->integer('company_id');
            $table->string('company_image');
            $table->string('company_name');
            $table->bigInteger('company_number');
            $table->integer('plan_status');
            $table->integer('plan_actived');
            $table->timestamp('plan_issued_date')->nullable();
            $table->integer('plan_paided_status');
            $table->bigInteger('plan_amount');
            $table->integer('billing_type');
            $table->timestamp('billing_start_date');
            $table->timestamp('billing_end_date');
            $table->integer('status');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->timestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
