<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('company_departments', function (Blueprint $table) {
            $table->id();
            $table->string('user_id')->unique();
            $table->string('logos')->nullable();
            $table->string('name');
            $table->string('short_name');
            $table->string('password');
            $table->integer('role');
            $table->integer('permission');
            $table->integer('total_auditor_active');
            $table->integer('total_auditor_inactive');
            $table->time('schedules_start_time');
            $table->time('schedules_end_time');
            $table->integer('plan_status');
            $table->rememberToken();
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->timestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('company_departments');
    }
};
