<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('schedules', function (Blueprint $table) {
            $table->id();
            $table->string('schedule_id');
            $table->integer('checklist_id');
            $table->integer('category_id');
            $table->integer('location_id');
            $table->integer('auditor_id');
            $table->integer('company_id');
            $table->timestamp('schedule_on');
            $table->time('start_time');
            $table->time('end_time');
            $table->string('reasons')->nullable();
            $table->string('other_message')->nullable();
            $table->timestamp('reschedule_on')->nullable();
            $table->time('re_start_time')->nullable();
            $table->time('re_end_time')->nullable();
            
            $table->integer('total_question')->nullable();
            $table->integer('total_ques_answered')->nullable();
            $table->integer('status')->nullable();
            $table->integer('action_status')->nullable();
            $table->integer('action_message')->nullable();
            $table->integer('reschedule_status')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->timestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('schedules');
    }
};
