<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('user_id');
            $table->string('avatar_img')->nullable();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->integer('role')->nullable();
            $table->integer('permission')->nullable();
            $table->integer('mobile_no')->nullable();
            $table->integer('gender')->nullable();
            $table->string('job_title')->nullable();
            $table->string('short_name')->nullable();
            $table->string('time_zone')->nullable();
            $table->integer('access_app')->nullable();
            $table->integer('access_web')->nullable();
            $table->integer('company_id')->nullable();
            $table->integer('plan_day_remain')->nullable();
            $table->integer('plan_actived')->nullable();
            $table->integer('plan_payment_status')->nullable();
            $table->integer('status')->nullable();
            $table->rememberToken();
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->timestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
