<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Schedule extends Model
{
    use HasFactory;
    public $timestamps = false;

    protected $fillable = [
        'schedule_id',
        'checklist_id',
        'category_id',
        'location_id',
        'auditor_id',
        'schedule_on',
        'total_question',
        'total_ques_answered',
        'company_id',
        'start_time',
        'end_time',
        'created_at',
        'created_by',
        'status'
    ];

    protected $hidden = [
        'deleted_by',
        'deleted_at'
    ];
    protected $dates = ['reschedule_on','schedule_on'];
    protected $casts = [
        'schedule_on' => 'datetime',
        'reschedule_on' => 'datetime',
        'start_time' => 'datetime:H:00',
        'end_time' => 'datetime:H:00',
        're_start_time' => 'datetime:H:00',
        're_end_time' => 'datetime:H:00',
        'created_at' => 'date:d M Y',
        'updated_at' => 'date:d M Y',
        'deleted_at' => 'date:d M Y'
    ];
}
