<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Results extends Model
{
    use HasFactory;
    public $timestamps = false;

    protected $fillable = [
        'result_id',
        'checklist_id',
        'category_id',
        'name',
        'symbols',
        'percentage',
        'color',
        'status',
        'created_by',
        'updated_by',
        'deleted_by',
        'created_at',
        'updated_at',
        'deleted_at'
    ];

    protected $hidden = [
        'deleted_by',
        'deleted_at'
    ];
    // protected $dates = ['reschedule_on','schedule_on'];
    protected $casts = [
        'created_at' => 'date:d M Y',
        'updated_at' => 'date:d M Y',
        'deleted_at' => 'date:d M Y'
    ];
}
