<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Plans extends Model
{
    use HasFactory;

    public $timestamps = false;
    public $table = "plans";

    protected $fillable = [
        'id',
        'title',
        'subtitle',
        'amount',
        'days',
        'feature',
        'status',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by',
    ];

    protected $hidden = [
        'created_by',
        'updated_by',
        'deleted_by',
        'deleted_at',
    ];
    protected $dates = [
        'created_at',
        'updated_at',
    ];
    protected $casts = [
       'created_at' => 'datetime',
       'updated_at' => 'datetime',
       'deleted_at' => 'datetime',
    ];
}
