<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Locations extends Model
{
    use HasFactory;
    public $timestamps = true;

    protected $fillable = [
        'location_id',
        'name',
        'time_zone',
        'address',
        'postcode',
        'company_id',
        'status',
        'created_by',
        'created_at',
        'updated_by',
        'deleted_by'
    ];

    protected $hidden = [
        'deleted_by',
        'deleted_at'
    ];
    
    protected $casts = [
        'created_at' => 'date:d M Y',
        'updated_at' => 'date:d M Y',
        'deleted_at' => 'date:d M Y'
    ];
}
