<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = [
        'id',
        'invoice_id',
        'transaction_id',
        'bank_id',
        'company_id',
        'company_image',
        'company_name',
        'company_number',
        'plan_status',
        'plan_actived',
        'plan_issued_date',
        'plan_paided_status',
        'plan_amount',
        'billing_type',
        'billing_start_date',
        'billing_end_date',
        'status',
        'created_by',
        'created_at'
    ];

    protected $hidden = [
        'created_by',
        'updated_by',
        'deleted_by',
        'deleted_at',
    ];
    protected $dates = [
        'created_at',
        'updated_at',
    ];
    protected $casts = [
        'created_at' => 'date:d M Y',
        'updated_at' => 'date:d M Y',
        'deleted_at' => 'date:d M Y'
    ];
}
