<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Feedback extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = [
        'id',
        'ticket_id',
        'user_id',
        'category',
        'client_message',
        'admin_message',
        'status',
        'created_at',
        'updated_at',
        'created_by',
        'updated_by',
    ];

    protected $hidden = [
        'created_by',
        'updated_by',
        'deleted_by',
        'deleted_at',
    ];
    protected $dates = [
        'created_at',
        'updated_at',
    ];
    protected $casts = [
       'created_at' => 'date:d M Y',
        'updated_at' => 'date:d M Y',
        'deleted_at' => 'date:d M Y'
    ];
}
