<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyDepartment extends Model
{
    use HasFactory;
    public $timestamps = true;
    protected $fillable = [
        'user_id',
        'logos',
        'name',
        'short_name',
        'password',
        'role',
        'permission',
        'total_auditor_active',
        'total_auditor_inactive',
        'schedules_start_time',
        'schedules_end_time',
        'plan_status',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
    ];

    protected $hidden = [
        'role',
        'remember_token',
        'password',
        'deleted_by',
        'deleted_at'
    ];

    protected $casts = [
        'created_at' => 'date:d M Y',
        'updated_at' => 'date:d M Y',
        'deleted_at' => 'date:d M Y',
        // 'schedules_start_time' => 'datetime:h:i A',
        // 'schedules_end_time' => 'datetime:h:i A'
        'schedules_start_time' => 'datetime:H:00',
        'schedules_end_time' => 'datetime:H:00',
    ];
}
