<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ChecklistQuestion extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = [
        'id',
        'questions_id',
        'title',
        'type',
        'option_array',
        'section_id',
        'checklist_id',
        'status',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by',
        'deleted_by',
    ];

    protected $hidden = [
        'id',
        'answer',
        'section_id',
        // 'checklist_id',
        // 'status',
        'created_by',
        'updated_by',
        'deleted_by',
        'deleted_at',
    ];
    protected $dates = [
        'created_at',
        'updated_at',
    ];
    protected $casts = [
        'created_at' => 'date:d M Y',
        'updated_at' => 'date:d M Y',
        'deleted_at' => 'date:d M Y',
        'option_array' => 'array'
    ];
}
