<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AuditReport extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = [
        'id',
        'audit_id',
        'user_id',
        'schedule_id',
        'checklist_id',
        'checklist_name',
        'location_id',
        'location_name',
        'audit_date',
        'signature_image',
        'status',
        'created_at',
        'updated_at',
        'created_by',
        'updated_by',
    ];

    protected $hidden = [
        'created_by',
        'updated_by',
        'deleted_by',
        'deleted_at',
    ];
    protected $dates = [
        'created_at',
        'updated_at',
    ];
    protected $casts = [
        'created_at' => 'date:d M, D',
        'updated_at' => 'date:d M, D',
        'deleted_at' => 'date:d M, D'
    ];

    public function schedule(){return $this->belongsTo(Schedule::class, 'schedule_id');}
    public function createdBy(){return $this->belongsTo(User::class, 'created_by');}
    public function checklist(){return $this->belongsTo(Checklist::class, 'checklist_id');}
    public function company(){return $this->belongsTo(CompanyDepartment::class, 'company_id');}

}
