<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AuditQuestionReport extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = [
        'id',
        'audit_id',
        'user_id',
        'schedule_id',
        'checklist_id',
        'checklist_name',
        'category_id',
        'category_name',
        'section_id',
        'section_name',
        'questions_id',
        'questions_name',
        'questions_answer',
        'questions_answer_array',
        'questions_image',
        'questions_comment',
        'questions_points',
        'questions_status',
        'status',
        'created_at',
        'updated_at',
        'created_by',
        'updated_by',
    ];

    protected $hidden = [
        'created_by',
        'updated_by',
        'deleted_by',
        'deleted_at',
    ];
    protected $dates = [
        'created_at',
        'updated_at',
    ];
    protected $casts = [
        'created_at' => 'date:d M, D',
        'updated_at' => 'date:d M, D',
        'deleted_at' => 'date:d M, D',
        'questions_image' => 'array',
        'questions_answer_array' => 'array'
    ];
}
