<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class RegistrationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'user_id' => ['required', 'string', 'min:2'],
            'first_name' => ['required', 'string', 'min:2'],
            'last_name' => ['required', 'string', 'min:2'],
            'email' => ['required', 'email:filter', 'unique:users'],
            'password' => ['required', 'string', 'min:2', 'confirmed'],
            'role' => ['required', 'string'],
            'permission' => ['required', 'string'],
            'country_name' => ['required', 'string'],
            'country_code' => ['required', 'string'],
            'mobile_no' => ['required', 'string'],
            'gender' => ['int'],
            'plan_day_remain' => ['int'],
            'plan_actived' => ['int'],
            'status' => ['int'],
            'created_by' => ['nullable','int']
        ];
    } 
}
