<?php

namespace App\Http\Requests\Dashboard;

use Illuminate\Foundation\Http\FormRequest;

class UpdatePlansRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'id' => ['required', 'string'],
            'title' => ['required', 'string'],
            'subtitle' => ['required', 'string'],
            'amount' => ['required', 'numeric'],
            'days' => ['required', 'integer'],
            'feature' => ['nullable', 'string'],
            'status' => ['required', 'string'],
        ];
    }
    public function messages(): array
    {
        return [
            'subtitle.required' => 'The Description field is required.',
        ];
    }
}
