<?php

namespace App\Http\Requests\Dashboard;

use Illuminate\Foundation\Http\FormRequest;

class UpdateDepartmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'id' => ['required', 'string'],
            'logos_image' => ['nullable', 'image'],
            'name' => ['required', 'string', 'min:2'],
            'schedules_start_time' => ['required', 'string'],
            'schedules_end_time' => ['required', 'string'],
            'password' => ['nullable', 'string'],
            'plan_status' => ['required', 'string'],
        ];
    }
}
