<?php

namespace App\Http\Requests\Dashboard;

use Illuminate\Foundation\Http\FormRequest;

class CreateScheduleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'schedule_id' => ['nullable', 'string'],
            'checklist_id' => ['required', 'string'],
            'category_id' => ['nullable', 'string'],
            'location_id' => ['required', 'string'],
            'auditor_id' => ['required','string'],
            'company_id' => ['required','string'],
            'schedule_on' => ['required','string'],
            'start_time' => ['required','string'],
            'end_time' => ['required','string'],
            'created_by' => ['nullable','string'],
            'created_at' => ['nullable','string'],
            'total_question' => ['nullable','string'],
            'total_ques_answered' => ['nullable','string'],
            'status' => ['nullable','string']
        ];
    }
}
