<?php

namespace App\Http\Requests\Dashboard;

use Illuminate\Foundation\Http\FormRequest;

class CreateDepartmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'logos_image' => ['nullable', 'image'],
            'name' => ['required', 'string', 'min:2'],
            'schedules_start_time' => ['required', 'string'],
            'schedules_end_time' => ['required', 'string'],

            'password' => ['required', 'string', 'min:2'],
            'role' => ['required', 'string'],
            'permission' => ['required', 'string'],
            'total_auditor_active' => ['required', 'string'],
            'total_auditor_inactive' => ['required', 'string'],
        ];
    }
}
