<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Razorpay\Api\Api;
use Illuminate\View\View;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Crypt;
use App\Models\User;
use App\Models\Plan;
use App\Models\Payment;
use App\Models\Invoice;
use App\Models\Gateway;
use Session;

class RazorpayPaymentController extends Controller
{
    public function index()
    {        
        return view('razorpay');
    }
  
    /**
     * Write code on Method
     *
     * @return response()
     */
    public function store(Request $request)
    {
        $input = $request->all();
  
        // $api = new Api(env('RAZORPAY_KEY'), env('RAZORPAY_SECRET'));

        $gateway = Gateway::orderBy('id', 'desc')->first();

        $api = new Api($gateway->key_value, $gateway->secret_value);
  
        $payment = $api->payment->fetch($input['razorpay_payment_id']);
  
        if(count($input)  && !empty($input['razorpay_payment_id'])) {
            try {
                $response = $api->payment->fetch($input['razorpay_payment_id'])->capture(array('amount'=>$payment['amount'])); 

                $id = Crypt::decrypt($request->id);

                $plan = Plan::find($id);

                $user = auth()->user();

                $user_plan = User::find($user->id);
                
                $lastInvoice = Invoice::orderBy('id', 'desc')->first();
            
                // If there is no previous invoice, start with 'IN-01'
                if (!$lastInvoice) {
                    $newInvoiceId = 'IN-01';
                } else {
                    // Extract the number part from the last invoice_id and increment it
                    $lastIdNumber = intval(str_replace('IN-', '', $lastInvoice->invoice_id));
                    $newIdNumber = $lastIdNumber + 1;
                
                    // Format the new ID with leading zeros if necessary (e.g., 'IN-01', 'IN-002')
                    $newInvoiceId = 'IN-' . str_pad($newIdNumber, 2, '0', STR_PAD_LEFT);
                }
                
                $remainingDays = $user_plan->plan_day_remain;
                $billingStartDate = now()->addDays($remainingDays);
                $billingEndDate = $billingStartDate->copy()->addDays($plan->days - 1); 
                
                $Invoice = Invoice::create([
                    'invoice_id' => $newInvoiceId,
                    'transaction_id' => $input['razorpay_payment_id'],
                    'bank_id' => 0,
                    'company_id' => $user->id,
                    'company_image' => $user->avatar_img ? $user->avatar_img : 'not available',
                    'company_name' => $user->first_name.' '.$user->last_name,
                    'company_number' => $user->mobile_no,
                    'plan_status' => 1,
                    'plan_actived' => $plan->id,
                    'plan_issued_date' => now(),
                    'plan_paided_status' => 1,
                    'plan_amount' => $plan->amount,
                    'billing_type' => 1,
                    // 'billing_start_date' => now(),
                    // 'billing_end_date' => now(),
                    'billing_start_date' => $billingStartDate,
                    'billing_end_date' => $billingEndDate,
                    'status' => 1,
                    'created_by' => $user->id,
                    'created_at' => now()
                ]);
                
            
                $Payment = Payment::create([
                    'plan_id' => $plan->id,
                    'amount' => $plan->amount,
                    'customer_name' => $user->first_name.' '.$user->last_name,
                    'paymentmethod_id' => $input['razorpay_payment_id'],
                ]);
            
            
            
                if ($user_plan) {
                    $user_plan->update(['plan_actived' => $id]); 
            
                    $user_plan->plan_day_remain += $plan->days;
                    $user_plan->save();
                }
            
                // return response()->json([
                //     'success' => true,
                //     'Message' => 'Payment Successful',
                // ]);
                $request->session()->flash('success', 'Payment Successful');
                return redirect()->route('subscription');
  
            } catch (Exception $e) {
                // return  $e->getMessage();
                // Session::put('error',$e->getMessage());
                // return redirect()->back();
                // return response()->json([
                //     'success' => false,
                //     'Message' => 'error',$e->getMessage(),
                // ]);
                $request->session()->flash('error', 'error',$e->getMessage());
                return redirect()->route('subscription');
            }
        }
          
        // Session::put('success', 'Payment successful');
        // return redirect()->back();
    }
}
