<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class UsersController extends Controller
{
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/users');

        // return dd($users);
        return view('pages.users.index', ['page_title' => 'Users Management'],compact('users'));
    }
    public function list()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/users');

        $category = [
            'data' => $users['data']['company_list']
        ];

        return $category;
    }
    /**
     * Show the form for creating a new resource.
     */
    public function details(Request $request)
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        // $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/users');
        $id = $request->route('id');
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/detail/users/'.$id,[
            'id' => $id
        ]);
        return view('pages.users.userdetails', ['page_title' => 'Users Details'],compact('users','id'));
    }
    public function company_department(Request $request)
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $id = $request->route('id');
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/detail/users/'.$id,[
            'id' => $id
        ]);
        $company_department = [
            'data' => $users['data']['company_list'][0]['company_department']
        ];

        return $company_department;
    }
    public function action_assignees(Request $request)
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $id = $request->route('id');
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/detail/users/'.$id,[
            'id' => $id
        ]);
        $action_assignees = [
            'data' => $users['data']['company_list'][0]['action_assignees']
        ];

        return $action_assignees;
    }
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();

        $id = $request->id;
        $status = $request->status;

        $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/update/users',[
            'id' => $id,
            'status' => $status,
        ]);
        $result = json_decode((string)$response->getBody(),true);
        
        

        if($result['status'] == true){
            return redirect()->route('users');
        }else{
            return redirect()->route('users');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
